<?php
$uncategorisedCategory = get_term_by('slug', 'uncategorised', 'category');
$newsCategories = get_categories(['hide_empty' => false, 'exclude' => $uncategorisedCategory->term_id]);
$queryObject = get_queried_object();
$years = \Blue2\Scruffy\Site::getPostsYears();
$themes = get_terms(['taxonomy'=> 'theme', 'hide_empty' => false]);
?>

<div class="custom-post-archive">
    <?php get_template_part('templates/sections/title-bar', null, [
        'title' => get_the_title(get_option('page_for_posts', true)),
        'description' => get_field('news_archive_description', 'option')
    ]); ?>

    <div class="contain">
        <div class="filter-output">
            <h2>Filter results:</h2>
            <div class="filter-holder">
                <ul class="filter-categories">
                    <li class="<?= is_home() ? 'active-filter' : ""; ?> fw-700"><a href="<?= get_the_permalink(get_option('page_for_posts', true)) ?>">All</a></li>
                    <?php if($newsCategories) {
                        foreach($newsCategories as $news) { ?>
                            <li class="<?= $queryObject->slug == $news->slug ? 'active-filter' : ""; ?> fw-700"><a href="<?= get_category_link($news->term_id); ?>"><?= $news->name; ?></a></li>
                        <?php } ?>
                    <?php } ?>
                </ul>
                <form class="sort-form">
                    <div class="form-item select-holder">
                        <label for="year" class="sr-only">Year</label>
                        <select id="year" name="year" class="fw-700">
                            <option value="">Search by year</option>
                            <?php foreach($years as $year) {
                                $selectedYear = isset($_GET['year']) && $_GET['year'] == $year['YEAR(post_date)'] ? 'selected' : ""; ?>
                                <option value="<?= $year['YEAR(post_date)'] ?>" <?= $selectedYear ?>><?= $year['YEAR(post_date)'];  ?></option>
                            <?php } ?>
                        </select>
                        <div class="custom-select-arrow"><span class="fas fa-chevron-down"></span></div>
                    </div>
                    <div class="form-item select-holder">
                        <label for="theme" class="sr-only">Theme</label>
                        <select id="theme" name="theme" class="fw-700">
                            <option value="">Search by theme</option>
                            <?php foreach($themes as $theme) {
                                $selectedTheme = isset($_GET['theme']) && $_GET['theme'] == $theme->slug ? 'selected' : ""; ?>
                                <option value="<?= $theme->slug ?>" <?= $selectedTheme ?>><?= $theme->name;  ?></option>
                            <?php } ?>
                        </select>
                        <div class="custom-select-arrow"><span class="fas fa-chevron-down"></span></div>
                    </div>
                    <div class="form-item">
                        <label for="keyword" class="sr-only">Keyword</label>
                        <input id="keyword" type="text" name="keyword" placeholder="Search by keyword" value="<?= isset($_GET['keyword']) && $_GET['keyword'] ? $_GET['keyword'] : "";  ?>">
                    </div>
                    <input type="submit" class="u-case fw-700" value="Search">
                </form>
            </div>
        </div>
    </div>

    <div class="archive-output">
        <div class="contain">
            <div class="row row-eq-height">
                <?php Blue2\Scruffy\Utils::archiveLoop(); ?>
            </div>
            <div class="custom-pagination">
                <?php
                the_posts_pagination([
                    'mid_size' => 1,
                    'prev_text' => __('Previous', 'textdomain'),
                    'next_text' => __('Next', 'textdomain'),
                    'before_page_number' => '<span class="meta-nav screen-reader-text">' . __('', '') . ' </span>',
                ]); ?>
            </div>
        </div>
    </div>
</div>



