<?php
$title = get_sub_field('title');
$description = get_sub_field('description');
$image = get_sub_field('image');
$ctaType = get_sub_field('cta_type');
$cta = $ctaType == 'link' ? get_sub_field('link') : get_sub_field('download');
$ctaTitle = $ctaType == 'link' ? get_sub_field('link')['title'] : get_sub_field('download_name');
?>
<div class="custom-flexible-section hero-section">
    <div class="contain">
        <div class="hero-wrapper">
            <div class="content-wrapper">
                <h1><?= $title; ?></h1>
                <div class="desc"><?= $description ?></div>
                <?php if($cta) { ?><div class="cta u-case fw-700"><a href="<?= $cta['url']; ?>"><?= $ctaTitle; ?></a></div> <?php } ?>
            </div>
            <div class="image-wrapper">
                <img src="<?= $image['url']; ?>" alt="<?= $image['url']; ?>">
            </div>
        </div>
    </div>

    <?php
    $path = get_template_directory() . '/dist/images/lines/line1.svg';
    $file = file_get_contents($path);
    $file = str_replace(
        '<?xml version="1.0" encoding="UTF-8"?>',
        '',
        $file
    );
    echo str_replace(
        '<svg',
        '<svg class="large-line" role="img" aria-label="Decorative SVG"',
        $file
    );
    ?>
</div>

