<?php
$colouredBlocks = get_sub_field('coloured_blocks');
$title = get_sub_field('coloured_section_title');
$subtitle = get_sub_field('coloured_section_subtitle');
?>
<section class="custom-flexible-section coloured-blocks">
    <div class="contain">
        <div class="title-section">
            <?php if($title) { ?><h2><?= $title; ?></h2><?php } ?>
            <?php if($subtitle) { ?><div class="sub-text"><?= $subtitle; ?></div><?php } ?>
        </div>


        <div class="row row-eq-height">
            <?php foreach($colouredBlocks as $block) { ?>
                <div class="col-md-6 block-col">
                    <div class="block-inner <?= 'color-' . $block['colour']; ?>">
                        <h3><?= $block['title']; ?></h3>
                        <div class="desc"><?= $block['description']; ?></div>
                        <?php if($block['cta']) { ?>
                            <div class="cta fw-700 u-case"><a href="<?= $block['cta']['url']; ?>"><?= $block['cta']['title']; ?></a></div>
                        <?php } ?>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>
</section>
