<?php
namespace Blue2\Scruffy\Controllers;

class PublicationController
{
    public function __construct()
    {
        $this->registerActions();
        $this->registerFilters();
    }

    private function registerActions()
    {
        add_action('init', [$this, 'registerTaxonomies']);
    }

    private function registerFilters()
    {
    }

    public function registerTaxonomies()
    {
        $type = new \Blue2\Common\Taxonomy("type", "Type", "Types", "publication", [], $args = [
            'show_ui' => true,
            'query_var' => true,
            'show_admin_column' => true,
        ]);
    }

    public static function getPublications($term) {
        $args = [
            'post_type' => 'publication',
            'numberposts' => -1,
            'post_status' => 'publish',
            'tax_query' => [
                [
                    'taxonomy' => 'type',
                    'field' => 'slug',
                    'terms' => [$term],
                    'operator' => 'IN',
                ]
            ]
        ];
        if(isset($_GET['keyword'])) {
            $args['s'] = $_GET['keyword'];
        }
        if(isset($_GET['year']) && $_GET['year'] !== "") {
            $args['date_query'] = [
                [
                    'year'  => $_GET['year']
                ],
            ];
        }
        if(isset($_GET['theme' ]) && $_GET['theme'] !== "") {
            $args['tax_query']['relation'] = 'AND';
            $args['tax_query'][] = [
                'taxonomy' => 'theme',
                'field' => 'slug',
                'terms' => [$_GET['theme']],
                'operator' => 'IN',
            ];
        }
        $publications = get_posts($args);
        return $publications;
    }

}
