<div class="<?= $args['name_plural']; ?> related-block">
    <div class="contain">
        <div class="top-holder">
            <h2><?= ucwords($args['name_plural']) ?></h2>
            <div class="navigation active">
                <div class="<?= $args['name_single']; ?>-prev">
                    <span class="fa-stack">
                        <span class="fas fa-circle fa-stack-2x"></span>
                        <span class="fas fa-chevron-left fa-stack-1x custom-chevron"></span>
                    </span>
                </div>
                <div class="<?= $args['name_single']; ?>-next">
                    <span class="fa-stack">
                        <span class="fas fa-circle fa-stack-2x"></span>
                        <span class="fas fa-chevron-right fa-stack-1x custom-chevron"></span>
                    </span>
                </div>
            </div>
        </div>

        <div class="related-view active">
            <div class="carousel-view">
                <div class="grid-1">
                    <div class="view-all-col u-case fw-700">
                        <span>View All</span>
                    </div>
                </div>
                <div class="grid-2">
                    <div class="swiper-container related-swiper <?= $args['name_single']; ?>-swiper">
                        <div class="swiper-wrapper">
                            <?php foreach($args['data'] as $post) {
                                setup_postdata($post);
                                $date = strtotime(get_the_date()); ?>
                                <div class="swiper-slide">
                                    <div class="related-item">
                                        <a href="<?= get_the_permalink(); ?>" target="_blank">
                                            <div class="read-more fw-700 u-case"><span>Read More</span></div>
                                            <div class="date"><?= date('F j, Y', $date) ?></div>
                                            <h3><?php the_title(); ?></h3>
                                        </a>
                                    </div>
                                </div>
                            <?php } wp_reset_postdata(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="related-view inactive">
            <div class="grid-view">
                <div class="grid-item">
                    <div class="view-all-col u-case fw-700">
                        <span>View Less</span>
                    </div>
                </div>
                <?php foreach($args['data'] as $post) {
                    setup_postdata($post);
                    $date = strtotime(get_the_date()); ?>
                    <div class="grid-item">
                        <div class="related-item">
                            <a href="<?= get_the_permalink(); ?>" target="_blank">
                                <div class="read-more fw-700 u-case"><span>Read More</span></div>
                                <div class="date"><?= date('F j, Y', $date) ?></div>
                                <h3><?php the_title(); ?></h3>
                            </a>
                        </div>
                    </div>
                <?php } wp_reset_postdata();  ?>
            </div>
        </div>
        <hr/>
    </div>
</div>
