<?php

/**
 * Template Name: Timeline Template
 */
?>
<div class="modal-transition-overlay"></div>
<script async src="https://platform.twitter.com/widgets.js" charset="utf-8"></script>
<?php

// Set initial decade...
$decade=1910;
$timelineOwl='<div class="timeline__modal"><span class="timeline__modal-close"><i class="timeline__modal-close-icon"></i></span><div class="timeline__owl-carousel">';
$categoryFilters='<ul class="timeline__cat-filter hidden">';
$categoryList=[];
$i=0;
$gridRowCount=0; ?>
<?php if( have_rows('timeline_items') ):  ?>

    <section class="timeline__grid">

        <?php while( have_rows('timeline_items') ): the_row();

            // vars
            $image = get_sub_field('image');
            $layout = get_sub_field('layout');

            // Count grid items - 5 cols = 1 row. If we have 6, force last item to a 1 grid col (Portrait) item.
            if( $layout == 'Landscape'){
                $gridRowCount=$gridRowCount+2;
            }else{
                $gridRowCount++;
            }
            if($gridRowCount==6){
                $layout='Portrait';
            }
            if($gridRowCount>4){
                $gridRowCount=0; // Reset counter at the end of a row.
            }
            $theme = get_sub_field('theme');
            $year = get_sub_field('year');
            $category = get_sub_field('category');
            $title = get_sub_field('title');
            $tweetTitle = substr($title,0,97);
            if(strlen($tweetTitle)<strlen($title)){
                $tweetTitle.='…';
            }
            $content = get_sub_field('content');
            $link = get_sub_field('link');
            $protocol = ((!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off') || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
            $url = $protocol . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
            ?>

            <?php
            $slideUrl=$url.'#'.$year.'-'.$i;
            $socialLinks = '<ul class="timeline-owl__social">';

            //$socialLinks.= '<a href="https://twitter.com/share?ref_src=twsrc%5Etfw" class="twitter-share-button" data-show-count="false">Tweet</a><script async src="https://platform.twitter.com/widgets.js" charset="utf-8"></script>';// '<li><a href="'..'"><i class="fa fa-twitter">';

            // FB share button in iframe - long load time...
            //  $socialLinks.='<li class="timeline-owl__social--fb"><div class="fb-share-button" data-href="'.$slideUrl.'" data-layout="button" data-size="large"><a target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=https%3A%2F%2Fdevelopers.facebook.com%2Fdocs%2Fplugins%2F&amp;src=sdkpreparse" class="fb-xfbml-parse-ignore">Share</a></div></li>';

            // FB share link, just href, quicker loading.
            $socialLinks.='<li class="timeline-owl__social--fb"><div class="fb-share-button--non-iframed" data-href="'.$slideUrl.'" data-layout="button" data-size="large"><a class="fa fa-facebook" target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=https%3A%2F%2Fdevelopers.facebook.com%2Fdocs%2Fplugins%2F&amp;src=sdkpreparse" class="fb-xfbml-parse-ignore"><span class="sr-only">Share</span></a></div></li>';

            $socialLinks.='<li class="timeline-owl__social--tw"><a class="twitter-share-button--no-iframe fa fa-twitter" href="https://twitter.com/intent/tweet?text=Explore%20the%20Carnegie%20UK%20Trust%20Timeline:%20'.$year.'%20'.$tweetTitle.'" data-url="'.$slideUrl.'" data-via="CarnegieUKTrust" data-size="large"><span class="sr-only">Tweet</span></a></li>';
            $socialLinks.='<li class="timeline-owl__social--link"><a href="'.$slideUrl.'"><i class="fa fa-link"></i></a></li><li class="timeline-owl__linkshare"><span class="timeline-owl__linkshare-copied-ok"></span><input type="text" value="'.$slideUrl.'" id="url'.$year.'-'.$i.'"></li>';

            $timelineOwl.='<div data-hash="'.$year.'-'.$i.'" data-slide="'.$i.'">';
            $timelineOwl.='<div class="timeline__img-col col1 col col-md-6 col--'.$layout.'">';
            if($image){
                $timelineOwl.='<img class="lazy" data-src="'.$image['url'].'" alt="'.$image['title'].'"/><div class="lds-dual-ring"></div>';
            }
            $timelineOwl.= $socialLinks.'</div>';
            $timelineOwl.='<div class="timeline__content-col col2 col col-md-5"><p class="timeline__year">'.$year.'</p>';
            $timelineOwl.='<p class="timeline__category timeline__category--'.$category.'">'.$category.'</p>';
            $timelineOwl.='<h2 class="timeline__title">'.$title.'</h2>';
            $timelineOwl.='<div class="timeline__content">'.$content.'</div>';
            $timelineOwl.='</div></div>';

            array_push($categoryList,$category);

            ?>

            <?php
            // Add decade anchor if needed.
            if ($year == $decade){
                $myYear=$year+1;
                $decade = ceil($myYear / 10) * 10;
                $decadeEcho = $decade-10;
                ?>
                <a id="decade-<?=$decadeEcho;?>" class="timeline_decade"><span class="sr-only"><?=$decadeEcho;?></span></a>
                <?php
            }elseif ( $year > $decade ){
                //$decade=$decade+10;
                $decade = ceil($year / 10) * 10;
                $decadeEcho = $decade-10;
                if($decadeEcho == 1910){
                    $decadeEcho = 1913;
                }
                ?>
                <a id="decade-<?=$decadeEcho;?>" class="timeline_decade"><span class="sr-only"><?=$decadeEcho;?></span></a>
                <?php
            }
            ?>
            <div class="timeline__grid-item timeline__grid-item--<?=$layout;?> timeline__grid-item--<?=$theme;?> timeline__grid-item--<?=$category;?>">
                <a id="timeline_year-<?=$year.'-'.$i;?>" data-slide="<?=$i;?>" class="timeline__link" href="#timeline_year-<?php echo $year.'-'.$i;?>">
                    <?php if ($image){?>
                        <img class="lazy" data-src="<?= $image['url']; ?>" alt="<?= $image['title'] ?>" />
                        <div class="lds-dual-ring"></div>
                    <?php } ?>
                </a>
                <div class="modal-content hidden">
                    <div data-hash="<?=$year.'-'.$i;?>" data-slide="<?=$i;?>">
                        <div class="timeline__img-col col1 col col-md-6 col--<?=$layout;?>">
                            <ul class="timeline-owl__social">
                                <li class="timeline-owl__social--fb"><div class="fb-share-button--non-iframed" data-href="<?=$slideUrl;?>" data-layout="button" data-size="large"><a class="fa fa-facebook" target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=https%3A%2F%2Fdevelopers.facebook.com%2Fdocs%2Fplugins%2F&amp;src=sdkpreparse" class="fb-xfbml-parse-ignore"><span class="sr-only">Share</span></a></div></li>
                                <li class="timeline-owl__social--tw"><a class="twitter-share-button--no-iframe fa fa-twitter" href="https://twitter.com/intent/tweet?text=Explore%20the%20Carnegie%20UK%20Trust%20Timeline:%20'<?=$year.'%20'.$tweetTitle?>" data-url="<?=$slideUrl;?>" data-via="CarnegieUKTrust" data-size="large"><span class="sr-only">Tweet</span></a></li>
                                <li class="timeline-owl__social--link"><a href="<?=$slideUrl;?>"><i class="fa fa-link"></i></a></li><li class="timeline-owl__linkshare"><span class="timeline-owl__linkshare-copied-ok"></span><input type="text" value="<?=$slideUrl;?>" id="murl<?=$year.'-'.$i;?>"></li>
                            </ul>
                        </div>
                        <div class="timeline__content-col col2 col col-md-5"><p class="timeline__year"><?=$year;?></p>
                            <p class="timeline__category timeline__category--<?=$category;?>"><?=$category;?></p>
                            <h2 class="timeline__title"><?=$title;?></h2>
                            <div class="timeline__content"><?=$content;?></div>
                        </div>
                    </div>
                </div>
                <div class="timeline__content">

                    <p class="timeline__category timeline__category--<?=$category;?>"> <?=$category;?> </p>
                    <h2 class="timeline__title"><?= $title; ?></h2>
                    <p class="timeline__year"><?= $year; ?></p>

                </div>

            </div>
            <div class="timeline__text visible-xs timeline__filtered-item timeline__filtered-item--<?=$category;?>">
                <div class="timeline__socials--mobile">
                    <?=$socialLinks;?>
                </div>
                <?=$content;?></div>
            <?php
            $i++;
        endwhile; ?>

        <?php
        $categoryList = array_unique($categoryList);
        foreach ($categoryList as $value) {
            $categoryFilters.='<li class="timeline__category--'.$value.'">'.$value.'</li>';
        }
        echo $categoryFilters.'</ul>'; ?>
        <div id="timeline__modal" class="timeline__modal" data-slide-total="<?= $i-1;?>">
            <span class="timeline__modal-close"><i class="timeline__modal-close-icon"></i></span>
            <div class="timeline__owl-carousel owl-loaded owl-drag">
                <div class="timeline-modal-content"></div>
                <div class="owl-nav">
                    <button type="button" role="presentation" class="owl-prev"><i class="timeline__arrow-left"></i><span class="timeline__arrow-bg"></span></button>
                    <button type="button" role="presentation" class="owl-next"><i class="timeline__arrow-right"></i><span class="timeline__arrow-bg"></span></button>
                </div>
            </div>
        </div>
    </section>
<?php endif; ?>

<script type="text/javascript">
    setTimeout(
        function(){
            var lazyLoadInstance = new LazyLoad({
                elements_selector: ".lazy",
                data_src: 'src'
            });
        },500);
</script>
