import Swiper from 'swiper';

const publication = () => {
    const sliderCount = $('.publication-block').length;
    for (let i = 1; i <= sliderCount; i++) {
        new Swiper(`.publication-swiper-${i}`, {
            breakpoints: {
                0: {
                    slidesPerView: 1,
                    spaceBetween: 32
                },
                576: {
                    slidesPerView: 2,
                    spaceBetween: 32
                },
                768: {
                    slidesPerView: 3,
                    spaceBetween: 32
                },
                992: {
                    slidesPerView: 4,
                    spaceBetween: 32
                },
                1300: {
                    slidesPerView: 5,
                    spaceBetween: 32
                },
            },
            watchOverflow: true,
            navigation: {
                nextEl: `.publication-next-${i}`,
                prevEl: `.publication-prev-${i}`,
            },
        });
    }
};
export default publication;
