<?php
$uncategorisedCategory = get_term_by('slug', 'uncategorised', 'category');
$publicationCategories = get_terms(['taxonomy'=> 'type', 'hide_empty' => false, 'exclude' => $uncategorisedCategory->term_id]);
$queryObject = get_queried_object();
$years = \Blue2\Scruffy\Site::getPostsYears('publication');
?>
<div class="custom-post-archive">
    <?php get_template_part('templates/sections/title-bar', null, [
        'title' => 'Publications',
        'description' => get_field('publication_archive_description', 'option')
    ]); ?>
    <div class="contain">
        <?php get_template_part('templates/sections/publication-filter'); ?>
    </div>
    <div class="archive-output">
        <div class="publication-output">
            <?php
            $pubCount = 0;
            foreach($publicationCategories as $category) {
                $pubCount++;
                $publications = \Blue2\Scruffy\Controllers\PublicationController::getPublications($category->slug); ?>
                <div class="related-block publication-block">
                    <div class="contain">
                        <div class="top-holder">
                            <h2><?= $category->name; ?></h2>
                            <div class="navigation active">
                                <div class="publication-prev-<?= $pubCount; ?>">
                                    <span class="fa-stack">
                                        <span class="fas fa-circle fa-stack-2x"></span>
                                        <span class="fas fa-chevron-left fa-stack-1x custom-chevron"></span>
                                    </span>
                                </div>
                                <div class="publication-next-<?= $pubCount; ?>">
                                    <span class="fa-stack">
                                        <span class="fas fa-circle fa-stack-2x"></span>
                                        <span class="fas fa-chevron-right fa-stack-1x custom-chevron"></span>
                                    </span>
                                </div>
                            </div>
                        </div>


                        <div class="related-view active">
                            <div class="carousel-view">
                                <div class="grid-1">
                                    <div class="view-all-col u-case fw-700">
                                        <a href="<?= get_category_link($category->term_id); ?>">
                                            <span>View All</span>
                                        </a>
                                    </div>
                                </div>
                                <div class="grid-2">
                                    <div class="swiper-container related-swiper publication-swiper-<?= $pubCount; ?>">
                                        <div class="swiper-wrapper">
                                            <?php foreach($publications as $publication) {
                                                $image = \Blue2\Scruffy\Site::acfImage(get_post_thumbnail_id($publication->ID), 'publication-image'); ?>
                                                <div class="swiper-slide">
                                                    <div class="publication-item">
                                                        <a href="<?= get_the_permalink($publication->ID); ?>">
                                                            <div class="image-wrapper <?= $image['class']; ?>">
                                                                <div class="read-more fw-700 u-case"><span>Read More</span></div>
                                                                <?= $image['output']; ?>
                                                            </div>
                                                            <h3 class="fw-700"><?= $publication->post_title; ?></h3>
                                                        </a>
                                                    </div>
                                                </div>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr/>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>
</div>
