#Scruffy Wordpress Theme

------

**Please read carefully before getting started on a new theme, as pull requests will be getting more strict as we all get used to the new coding standards.**

## How to install

###Planet Express Entry
For new Scruffy sites to work, you **must** add add a version number of 3 to the array. Example:

```php
"example.site" => [
    "database" => "pex_example",
    "s3_prefix" => "example",
    "version" => 3
],

```

###Creating a new theme for Hubert
Windows Powershell:

`$> ./bin/create-theme.ps1`

Once the theme is installed you **must** update the `themeName` variable in `/assets/webpack.config.js`. This should match your theme directory, e.g. 'blue2-theme'.

###A Plugin is no longer required
The functionality that we previously wrote in the plugin, has been merged into the Blue2 Common plugin. By default there is an `Event` class that extends from `BasePost`. This registers a post type of 'event'. 
There is also an empty `Controllers` directory to encourage a uniform theme src structure.

## Theme specific coding standards:

### Root Files:

In Scruffy we should try to keep the root files as tidy as possible, in almost all cases these should just be one line of php referenceing a function from Utils.php

For example a template file in the root should just reference: `Blue2\Scruffy\Utils::simpleWrappedLoop('TEMPLATE_NAME');`

### Code Splitting:

####PHP:
Try and keep php files easy to understand by making use of the `get_template_part()` function and/or shortcodes.

For example if you are using an ACF flexible content field, instead of putting the markup for each different section all into one template file, split this up into reusable parts that can just be included through the loop as needed.

By default there is a sections directory within templates. The function `Blue2\Scruffy\Utils::flexibleLoop()` will loop over flexible content fields named `sections` and search the sections directory for templates matching the row layout name.

Try and think about which parts in a template can be reused on the site and isolate these so they can just be included and we aren't constantly repeating HTML/PHP.

####Javascript
JS code should at least be split into files for each page. These files can just contain plain javascript that will run when imported, export multiple functions, export a default function or Javscript class objects. Any combination of these can be used.

For example, you could write a js file containing all of your code for the 'single-event' page. This file contains all javascript formats that will run successfully.

```javascript
console.log('This will run on import');

function demo () {
    console.log('demo function');
}
demo(); //This runs the above function on import.

export const thisMustBeImported = () => {
    ...
    // This is a function that must be imported
    // since it is not called within this file
}

const event = function() {
    console.log("All event stuff happens here");
};

export default event; Team
```

Now in `app.js` you can import and use this file using the `load()` function
```javascript
const route = className => {
    switch (className) {
        case 'single_event':
            load('./path/to/import')
            break;
    };
};
```

This function imports the file only when required, so in the above example, only when you are on the single event page. It will run javascript on import, and run all exported functions. You can pass an optional boolean to only run the default exported function. This will not stop plain javascript from running, only other functions.

Functions do not need to follow new ESNext syntax, however if you wish the same event function could be written as:

```javascript
const event = () => { // Braces are a function
    console.log("ESNext function");
}

const event = () => ( //Brackets will instantly return the contents
    'this is a string'
);

export default event;
```

Code is fired if the body contains a class that is within the switch. Code that is required on all pages should be within common.js.

ESNext syntax should be used for declaring variables. `const` declares a variable that cannot be altered. And `let` declares a variable that can be altered. `let` is scoped the the braces that it is contained within.

During the build process, ESLint is used to test JS code. Most IDE's have support for ESLint to lint as you type.

PHPStorm should have this enabled by default, however if not follow this setup: https://www.jetbrains.com/help/phpstorm/eslint.html

VS Code requires an extension to be installed. It can then be configured to lint on save: https://marketplace.visualstudio.com/items?itemName=dbaeumer.vscode-eslint

To make use of Swiper, which is included by default, you must import the library with an absolute path. This solves some IE11 issues
```javascript
import Swiper from 'swiper/dist/js/swiper.js';
import 'swiper/dist/css/swiper.css';

new Swiper('.swiper-container');
```



####CSS
CSS Should at a minimum be split into different files for the template that it is used on i.e CSS relating to a custom post type of "events" should be put into the _events.scss file.

CSS that applies to the header/footer should also have their own corresponding _scss files.

Mobile first design will now be enforced so consider this before starting to write your css. For example, write all the mobile css for a section first, then use `include media-breakpoint-up()` to style for desktop.

Breakpoint down functions or max-width media queries can be used but they should be used sparingly.

------

## PHP Coding standards:

PHP Coding standards can be found at https://bitbucket.org/blue2digital/dev-manual/src/master/code-standards/php-standards.md
