<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="profile" href="http://gmpg.org/xfn/11">
    <link href="https://fonts.googleapis.com/css?family=Raleway:400,700|Roboto:400,500" rel="stylesheet">
    <?php wp_head(); ?>
</head>
<?php
    $pageBg = get_field('page_background_image');
    $altBg = get_field('alt_page_background_image','options');
    if(!$pageBg){
        $pageBg = get_field('default_page_background_image','options');
        $class='';
        if(is_product() && $altBg){
            $pageBg = $altBg;
            $class = 'alt_bg';
        }
    }
    ?>
    
<body <?php body_class($class); ?> style="background-image: url(<?=$pageBg['url']; ?>);" id="<?php if(is_shop()) { echo 'main-shop-page'; } ?>">
<script>document.body.className += ' fade-out';
    setTimeout(
        function () {
            document.querySelector('body').classList.remove('fade-out');
        }
        , 500
    );
    </script>
    <!-- Google Tag Manager (noscript) -->
    <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-WHD5RGN"
    height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
    <!-- End Google Tag Manager (noscript) -->