<div class="shop-container">
    <h1><?php the_title();?></h1>
    <?php $args = [
        'post_type' => 'product',
        'tax_query' => [
            [
                'taxonomy' => 'product_cat',
                'field' => 'slug',
                'terms' => 'bundle',
                'operator' => 'NOT IN',
            ]
        ]
    ];
    $standardProductLoop = new WP_Query( $args );
    if($standardProductLoop->have_posts()) { ?>
        <div class="row">
            <?php while ( $standardProductLoop->have_posts() ) {
                $standardProductLoop->the_post();
                $productID = get_the_id(); ?>
                <div class="fix-product-archive fixed-product__layer--top">
                    <?php
                        $prodLink = get_field('product_link', $productID);
                        if(!$prodLink){
                            $prodLink = get_permalink( $productID );
                        }
                    ?>
                    <a class="product-link--archive" href="<?=$prodLink;?>">View product</a>
                    <?= do_shortcode('[product_page id="' . $productID . '"]'); ?>
                </div>
            <?php } ?>
        </div>
    <?php }  ?>

    <div class="row archive-bundles">
        <?php $giftArgs = [
            'post_type' => 'product',
            'tax_query' => [
                [
                    'taxonomy' => 'product_cat',
                    'field' => 'slug',
                    'terms' => 'bundle',
                ]
            ]
        ];
        $giftLoop = new WP_Query( $giftArgs );
        if($giftLoop->have_posts()) { ?>
            <?php while ( $giftLoop->have_posts() ) {
                $giftLoop->the_post();
                $productID = get_the_id(); ?>
                <div class="single-product-archive fixed-product__layer--top">
                    <?= do_shortcode('[product_page id="' . $productID . '"]'); ?>
                </div>
            <?php } ?>
        <?php }   ?>
    </div>
</div>