import '@babel/polyfill'; // Required for build
import load from './loader'; // Required for loading files dynamically
import 'bootstrap/js/dist/util'; // All Bootstrap JS requires Util
import 'bootstrap/js/dist/collapse'; // Used for nav collapse functionality
import 'bootstrap/js/dist/modal';
import '@fortawesome/fontawesome';
import '@fortawesome/fontawesome-free-brands';
// import '@fortawesome/fontawesome-pro-solid';
// import '@fortawesome/fontawesome-pro-regular';
import '@fortawesome/fontawesome-pro-light';

import common from './common';
/*
    Basic Event Routing
    -------------------
    Switch on body class that gets applied either due to page, post type or page template
    Replace '-' in the class name with '_'
*/
const route = className => {
    switch (className) {

        case 'single_post':
            load('./post');
            break;

    }
};

// Fire events once document has loaded
document.addEventListener('DOMContentLoaded', () => {
    common(); // Run common code on every page
    let value;
    const bodyClasses = document.body.className // Get all body classes,
        .replace(/-/g, '_') // replace dashes with underscores,
        .replace(/page_template_/g, '') // remove prefix 'page_template' from template classes, &
        .split(/\s+/); // split on whitespace

    for (value of bodyClasses) {
        route(value); // Run javascript for each body class
    }
});
