<?php
$logo = get_field('company_logo', 'options')['url'];
$paymentCards = get_field('payment_cards', 'options');
$paymentProcessLogo = get_field('payment_process_logo', 'options');
$video = get_field('page_background_video');
?>
</main>
<?php if($video) { ?>
<video autoplay="autoplay" muted loop class="background-video">
    <source src="<?= $video['url']; ?>" type="video/mp4">
</video>
<?php } ?>
<section class="da_panel">
    <div class="da_panel__content">
        <div class="frame_el--da">
        </div>
        <div class="frame_el--da">
        </div>
        <div class="da_logo_wrapper col col-sm-10 offset-sm-1 col-md-8 offset-md-2">
            <img class="img-fluid" src="<?= $logo; ?>" alt="<?php bloginfo('name'); ?>" />
            <p class="lead">DRINK AWARE</p>
        </div>
        <p class="lead"><?php the_field('da_main_text', 'options'); ?></p>
        <a class="btn btn-primary da_btn" href="/"><span>Enter Site</span></a>
        <p><?php the_field('da_secondary_text', 'options'); ?></p>
    </div>
</section>
<?php
    $activatePopup = get_field('activate_popup', 'options');

    if ($activatePopup && is_front_page()) {
?>
    <section class="da_panel_product">
        <div class="da_panel_product__content ">
            <a class="btn btn-primary da_btn_product" href="/"><span>X</span></a>
            <?php
                $popupContent = get_field('popup_content', 'options');
            ?>
            <div class="popup-inner">
                <?= $popupContent ?>
            </div>
        </div>
    </section>
<?php
    }
?>
<footer class="site-footer">
    <div class="container-fluid">
        <div class="row">
            <nav class="navigation navigation--footer col-lg-5">
                <button class="btn btn-primary d-sm-none align-self-center" data-toggle=".quick-links__footer">
                    <span>Quick Links</span>
                </button>
                <?php if (has_nav_menu('footer_menu')) {
                    wp_nav_menu(['theme_location' => 'footer_menu', 'menu_class' => 'quick-links__footer']);
                } ?>
            </nav>
            <nav class="social-media col-md-4 col-lg-2 text-center">
                <?php if (have_rows('social_media_channels', 'option')) { ?>
                <p>
                    <?php while (have_rows('social_media_channels', 'option')) {
                            the_row(); ?>
                    <a href="<?php the_sub_field('full_url'); ?>" target="_blank" rel="noopener"><i
                            class="<?php the_sub_field('fa5_icon_class'); ?>"></i></a>
                    <?php } ?>
                </p>
                <?php } ?>
            </nav>
            <div class="sign-up col-md-8 col-lg-5">
                <div class="payment-row row">
                    <div class="col">
                        <img class="img-fluid" src="<?= $paymentCards['url']; ?>"
                            alt="<?= $paymentCards['title']; ?>" />
                    </div>
                    <div class="col col-lg-5">
                        <img class="img-fluid" src="<?= $paymentProcessLogo['url']; ?>"
                            alt="<?= $paymentProcessLogo['title']; ?>" />
                    </div>
                </div>
                <p>Want to learn more about our latest drinks &amp; product launches?</p>
                <form
                    action="https://calculontheme.us19.list-manage.com/subscribe/post-json?u=bc860e2aefbb79a24a6277854&amp;id=fc62f2149a&c=?"
                    method="get" id="mc-embedded-subscribe-form" name="mc-embedded-subscribe-form" class="validate"
                    target="_blank" novalidate>
                    <label for="newsletter-signup">
                        Sign up to our newsletter:
                    </label>
                    <div class="form-wrapper">
                        <input type="email" value="" name="EMAIL" class="email" id="mce-EMAIL"
                            placeholder="Please enter your email address..." required>
                        <!-- real people should not fill this in and expect good things - do not remove this or risk form bot signups-->
                        <div style="position: absolute; left: -5000px;" aria-hidden="true"><input type="text"
                                name="b_d1b3516dea2ce7b5f404ef446_c77a838f81" tabindex="-1" value=""></div>
                        <button type="submit" value="Subscribe" name="subscribe" id="mc-embedded-subscribe"
                            class="btn btn-secondary btn-compact"><span>GO</span></button>
                    </div>
                </form>
                <div id="mc-embedded-subscribe-mce-responses">
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-2 offset-lg-5 text-center">
                <img class="brand filter--white img-fluid" src="<?= $logo; ?>" alt="<?php bloginfo('name'); ?>" />
            </div>
        </div>
        <div class="row sub-footer">
            <div class="col-lg-5 text-center">
                <ul class="list-inline">
                    <a href="/terms">
                        <li class="list-inline-item">Terms</li>
                    </a>
                    <a href="/cookies">
                        <li class="list-inline-item">Cookie policy</li>
                    </a>
                    <a href="/privacy-policy">
                        <li class="list-inline-item">Privacy Policy</li>
                    </a>
                </ul>
            </div>
            <div class="copyright col-lg-2 text-center">
                <p>&copy; <?= date("Y"); ?> <?php bloginfo('name'); ?></p>
            </div>

            <div class="credit col-lg-5">
                <p><span>Website Powered by </span><?= do_shortcode('[blue2_logo type="light"]'); ?></p>
            </div>
        </div>
    </div>
    <div class="page-frame--footer">
    </div>
</footer>