<?php

namespace Blue2\Scruffy\Controllers;

class BusinessController
{
    public function __construct()
    {
        $this->registerActions();
        $this->registerTaxonomies();
    }

    private function registerActions() {
        add_action('wp_head', [$this, 'loadGlobalVar']);
        add_action('wp_ajax_loadBusiness', [$this, 'loadBusinessAjaxHandler']);
        add_action('wp_ajax_nopriv_loadBusiness', [$this, 'loadBusinessAjaxHandler']);
        add_action('pre_get_posts', [$this, 'orderBusinesses']);
        add_action('pre_get_posts', [$this, 'setBusinessDirectoryPostsPerPage']);
    }

    public static function registerTaxonomies()
    {
        $businessCategory = new \Blue2\Common\Taxonomy(
            "business-category",
            "Business Category",
            "Business Categories",
            "business",
            [
                'public' => true,
                'show_in_menu' => true,
                'show_admin_column' => true
            ]
        );

        $accessibilityCategory = new \Blue2\Common\Taxonomy(
            "accessibility-category",
            "Accessibility Category",
            "Accessibility Categories",
            "business",
            [
                'public' => true,
                'show_in_menu' => true,
                'show_admin_column' => true
            ]
        );

    }

    public function setBusinessDirectoryPostsPerPage( $query ) {
        if ( !is_admin() && $query->is_main_query() && is_post_type_archive( 'business' ) ) {
            $postsPerPage = get_field('business_posts_per_page', 'option') ?: -1;
            $query->set( 'posts_per_page', $postsPerPage );
        }
    }

    public function loadBusinessAjaxHandler()
    {

        $postsPerPage = get_field('business_posts_per_page', 'option') ?: -1;
        $paged = $_POST['paged'] ?: 1;

        $args['post_type'] = 'business';
        $args['post_status'] = 'publish';
        $args['posts_per_page'] = $postsPerPage;
        $args['paged'] = $paged;

        if (isset($_POST['searchPosts'])) {
            $args['s'] = $_POST['searchPosts'];
        }
        $args['tax_query'] = ['relation' => 'AND'];

        if (isset($_POST['business']) && $_POST['business'] != 'all' && $_POST['business'] != '') {
            $args['tax_query'][] = [
                [
                    'taxonomy' => 'business-category',
                    'field' => 'id',
                    'terms' => explode(",", $_POST['business']),
                ],
            ];
        }

        if (isset($_POST['accessibility']) && $_POST['accessibility'] != 'all' && $_POST['accessibility'] != '') {
            $args['tax_query'][] = [
                [
                    'taxonomy' => 'accessibility-category',
                    'field' => 'id',
                    'terms' => explode(",", $_POST['accessibility']),
                ],
            ];
        }

        $args['meta_key'] = 'featured';
        $args['orderby'] = ['meta_value' => 'DESC', 'title' => 'ASC'];

        query_posts($args);
        ?>
        <script>
            var max_page = <?= count(query_posts($args)); ?>;
        </script>
        <?php
        if (have_posts()) {
            while (have_posts()) {
                the_post();
                get_template_part('templates/business/content');
            } ?>
            <div class="business-list" data-current-page="<?= (get_query_var('paged')) ? get_query_var('paged') : 1; ?>">
                <?php
                the_posts_pagination([
                    'mid_size' => 100,
                    'prev_text' => __('<', 'textdomain'),
                    'next_text' => __('>', 'textdomain'),
                    'screen_reader_text' => ' ',
                    'before_page_number' => '',
                ]); ?>
            </div>

        <?php } else {
            echo '<div class="no-results-found">There were no results found.</div>';
        }
        die;
    }

    public static function loadGlobalVar()
    {
        global $wp_query;
        ?>
        <script type="text/javascript">
            const ajaxurl = <?= json_encode(admin_url("admin-ajax.php")); ?>;
            const ajaxnonce = <?= json_encode(wp_create_nonce("itr_ajax_nonce")); ?>;
            var posts = <?= json_encode($wp_query->query_vars); ?>;
        </script><?php
    }

    public static function orderBusinesses($query)
    {
        if (is_post_type_archive('business') && !is_admin() && $query->is_main_query()) {
            $query->set('meta_key', 'featured');
            $query->set('orderby',['featured' => 'DESC', 'title' => 'ASC']);
        }
    }

    public static function getAdditionalLocations() {
        $pins = [];
        $additionalLocations = get_field('additional_locations');
        $locationCount = 0;
        if($additionalLocations) {
            foreach($additionalLocations as $location) {
                $pins[$locationCount] = $location['location'];
                $pins[$locationCount]["name"] = get_the_title();
                $pins[$locationCount]["business_address"] = $location["location"]["address"];
                $locationCount++;
            }
            return json_encode($pins);
        } else {
            return;
        }
    }


}
