<?php

$termArgs = [
    'taxonomy' => 'business-category',
    'parent' => 0,
    'hide_empty' => false,
];
$terms = get_terms($termArgs);
?>

<div class="business-banner">
    <div class="custom-container">
        <?php if ( function_exists('yoast_breadcrumb') ) {
            yoast_breadcrumb( '<div class="custom-breadcrumbs"><p id="breadcrumbs">','</p></div>' );
        } ?>
        <h1>Business Directory</h1>
    </div>
</div>

<section class="business-directory business-directory__bg">
    <div class="container-fluid">


        <div class="row">
            <div class="business-directory__filter">
                <form action="<?=admin_url('admin-ajax.php');?>" method="POST" id="business-search" class="business-directory__form">
                    <div class="to-results"><a class="scrollToTgt" href="#search_results">view results</a></div>
                    <div class="business-directory__row business-directory__row--header business-directory__row--between business-directory__row--padding business-directory__row--border-bottom">
                        <div class="business-directory__title business-directory__title--secondary-light business-directory__title--filter">
                            Refine Results
                        </div>

                        <div class="form-clear">
                            <a href="<?php get_permalink() ?>">
                                <span>Clear</span>
                                <i class="far fa-times-circle"></i>
                            </a>
                        </div>
                    </div>

                    <div class="business-directory__row business-directory__row--border-bottom">
                        <div class="business-search-form">
                            <div class="input-group">
                                <input type="text" name="searchPosts" placeholder="Search Businesses..." class="form-control" id="searchTerm" value="<?= (isset($_POST['searchPosts']) ? $_POST['searchPosts'] : ''); ?>" autocomplete="off"/>
                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-search" id='searchBtn'><i class="fas fa-search"></i></button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <?php if ($terms) {
                        foreach ($terms as $term) {?>
                            <div class="business-directory__filter-section">
                                <div class="business-directory__filter-section__inner">
                                    <a href="#<?=$term->slug;?>-filter" class="business-directory__filter-section__title collapsed" data-toggle="collapse" role="button" aria-expanded="false" aria-controls="<?=$term->slug;?>-filter">
                                        <?=$term->name;?>
                                    </a>
                                    <div id="<?=$term->slug;?>-filter" class="custom-filter collapse">
                                        <div>
                                            <input type="checkbox" id="<?=$term->slug;?>-all" name="term" data-category="business-category" class="business-filter" />
                                            <label for="<?=$term->slug;?>-all">All</label>
                                        </div>
                                        <?php
                                        $childArgs = [
                                            'taxonomy' => 'business-category',
                                            'parent' => $term->term_id,
                                            'hide_empty' => false,
                                        ];
                                        $childTerms = get_terms($childArgs);

                                        if ($childTerms) {
                                            foreach ($childTerms as $childTerm) {
                                                ?>
                                                <div>
                                                    <input type="checkbox" value="<?=$childTerm->term_id; ?>" id="<?=$childTerm->slug; ?>" data-category="business-category" name="term" class="business-filter" />
                                                    <label for="<?=$childTerm->slug; ?>"><?=$childTerm->name; ?></label>
                                                </div>
                                                <?php
                                            }
                                        } ?>
                                    </div>
                                </div>
                            </div>
                        <?php }
                    } ?>

                    <!-- Accessibility Section -->
                    <?php
                    $accessibilityArgs = [
                        'taxonomy' => 'accessibility-category',
                        'parent' => 0,
                        'hide_empty' => false,
                    ];
                    $accessibility = get_terms($accessibilityArgs);
                    if ($terms) {
                        ?>
                            <div class="business-directory__filter-section">
                                <div class="business-directory__filter-section__inner">
                                    <a href="#accessibility-filter" class="business-directory__filter-section__title collapsed" data-toggle="collapse" role="button" aria-expanded="false" aria-controls="<?=$term->slug;?>-filter">
                                        Accessibility Options
                                    </a>
                                    <div id="accessibility-filter" class="collapse">
                                        <div>
                                            <input type="checkbox" id="accessibility-all" name="term" data-category="accessibility-category" class="business-filter" />
                                            <label for="accessibility-all">All</label>
                                        </div>
                                        <?php
                                        $childTerms = get_terms($childArgs);
                                            foreach ($accessibility as $access) {
                                                ?>
                                                <div>
                                                    <input type="checkbox" value="<?=$access->term_id; ?>" id="<?=$access->slug; ?>" data-category="accessibility-category" name="term" class="business-filter" />
                                                    <label for="<?=$access->slug; ?>"><?=$access->name; ?></label>
                                                </div>
                                                <?php
                                            } ?>
                                    </div>
                                </div>
                            </div>
                        <?php
                    }
                    ?>
                    <input type="hidden" name="action" value="loadBusiness">
                </form>

                <div class="business-request-form-button">
                    <a href="/business-directory-form/">List Your Business for Free</a>
                </div>

            </div>
            <div class="business-directory__results" id="search_results" style="background-image:url('<?= get_template_directory_uri() . '/dist/images/foreground.png'; ?>')">
                <div class="business-directory__row business-directory__row--between business-directory__row--margin-bottom d-flex">
                    <div class="business-directory__grid-type" id="business-grid-type">
                    <span class="view-span">
                        View:
                    </span>
                        <a href="#" data-type="long" class="active">
                            <span class="fa-stack">
                              <i class="fal fa-circle fa-stack-2x"></i>
                              <i class="fas fa-th-list fa-stack-1x"></i>
                            </span>
                        </a>
                        <a href="#" data-type="grid">
                            <span class="fa-stack">
                              <i class="fal fa-circle fa-stack-2x"></i>
                              <i class="fas fa-th fa-stack-1x"></i>
                            </span>
                        </a>
                    </div>
                </div>
                <div class="business-directory__results-inner">
                    <div id="business-results" class="business-directory__row business-directory__row--grey">
                        <?php Blue2\Scruffy\Utils::archiveLoop(); ?>
                        <div class="business-list" data-current-page="<?= (get_query_var('paged')) ? get_query_var('paged') : 1; ?>">
                            <?php
                            the_posts_pagination([
                                'mid_size' => 100,
                                'prev_text' => __('<', 'textdomain'),
                                'next_text' => __('>', 'textdomain'),
                                'screen_reader_text' => ' ',
                                'before_page_number' => '',
                            ]); ?>
                        </div>
                    </div>

                    <div class="business-directory__loading" id="business-loading">
                        <div>Loading...</div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</section>
