import Swiper from 'swiper';

const common = () => {
    if ($('.bio-swiper').length) {
        new Swiper('.bio-swiper', {
            autoplay: {
                delay: 3000,
            },
            loop: true,
            breakpoints: {
                992: {
                    slidesPerView: 2,
                    spaceBetween: 25
                },
                1500: {
                    slidesPerView: 3,
                    spaceBetween: 25
                }
            },
            navigation: {
                nextEl: '.swiper-button-next',
                prevEl: '.swiper-button-prev',
            },
            pagination: {
                el: '.swiper-pagination',
                clickable: true
            },
        });
    }

    function createMapMarker(mapData, map) {
        const google = window.google;
        const bounds = new google.maps.LatLngBounds();
        const latLng = new google.maps.LatLng(mapData.lat,mapData.lng);
        const marker = new google.maps.Marker({
            position: latLng,
            map,
        });
        const address = (typeof mapData.address !== 'undefined') ? mapData.address : '';
        const contentString = `<h5><strong>${address}</strong></h5>`;
        const infowindow = new google.maps.InfoWindow({
            content: contentString
        });
        function makeInfoWindowEvent(map, infowindow, marker) {
            google.maps.event.addListener(marker, 'click', function() {
                infowindow.open(map, marker);
            });
        }
        makeInfoWindowEvent(map, infowindow, marker);
    }

    if ($('#map').length) {
        const google = window.google;
        const location = $('#map');
        const mapLng = location.data('lng');
        const mapLat = location.data('lat');
        const mapZoom = 9;
        const mapCenter = { lat: mapLat, lng: mapLng };
        const map = new google.maps.Map(document.getElementById('map'), {
            zoom: mapZoom,
            center: mapCenter,
            scrollWheel: false,
            streetViewControl: false,
        });

        if ($('.custom-business-single').length) {
            new google.maps.Marker({
                position: mapCenter,
                map,
            });

            let multiMarkers = $('.additional-locations').attr('data-multi-pins');
            if (multiMarkers) {
                multiMarkers = JSON.parse($('.additional-locations').attr('data-multi-pins'));
                for (let i = 0; i < multiMarkers.length; i++) {
                    createMapMarker(multiMarkers[i], map);
                }
            }
        }
    }
};

export default common;
