<footer class="site-footer">
    <div class="custom-container">
        <div class="container-fluid">
            <div class="row">
                <nav class="col-lg-4 footer-logo">
                    <div class="footer-images">
                        <?php
                        $footerImage = get_field('footer_image', 'option');
                        $secondaryFooterImage = get_field('secondary_footer_image', 'option');
                        if($footerImage){ ?>
                            <img src="<?= $footerImage['url']; ?>" alt="Dundee & Angus Chamber of Commerce" class="primary-footer-image">
                        <?php }
                        if($secondaryFooterImage) { ?>
                            <img src="<?= $secondaryFooterImage['url']; ?>" alt="Angus Council" class="primary-footer-image">
                        <?php } ?>
                    </div>

                </nav>
                <nav class="navigation col-lg-4">
                    <?php if (have_rows('social_media_channels', 'option')) { ?>
                        <div class="social-media">
                            <ul>
                                <?php
                                while (have_rows('social_media_channels', 'option')) {
                                    the_row();
                                    ?>
                                    <li><a href="<?php the_sub_field('full_url'); ?>" target="_blank" rel="noopener"><i class="<?php the_sub_field('fa5_icon_class'); ?>"></i></a></li>
                                    <?php
                                }
                                ?>
                            </ul>
                        </div>
                    <?php } ?>
                    <?php
                    if (has_nav_menu( 'footer_menu' )) {
                        wp_nav_menu(['theme_location' => 'footer_menu', 'menu_class' => '']);
                    }
                    ?>
                    <?php
                    if (has_nav_menu( 'secondary_footer_menu' )) {
                        wp_nav_menu(['theme_location' => 'secondary_footer_menu', 'menu_class' => '']);
                    }
                    ?>
                    <p class="copyright">&copy; <?= date("Y"); ?> <?php bloginfo('name'); ?></p>
                </nav>
                <div class="credit col-lg-4">
                    <p>Website by <?php echo do_shortcode( '[blue2_logo type="dark"]' ); ?></p>
                </div>
                <div class="copyright col-12 text-center">

                </div>
            </div>
        </div>
    </div>
</footer>
