$(window).load(() => {
    $('a.business-directory__filter-section__title').click(function() {
        $(this).parent('.business-directory__filter-section__inner')
            .toggleClass('active');
        $('.business-list').data('current-page', 1);
    });

    $('#business-grid-type > a').click(function(e) {
        if (!$(this).hasClass('active')) {
            $(this).siblings()
                .each((index, obj) => {
                    $('.business__item').removeClass($(obj).data('type'));
                    $(obj).removeClass('active');
                });

            const type = $(this).data('type');
            $('.business__item').toggleClass(type);
            $(this).toggleClass('active');
        }

        e.preventDefault();
    });

    const $loading = $('#business-loading').hide();
    $(document).ajaxStart(() => {
        $loading.show();
    })
        .ajaxStop(() => {
            $loading.hide();
        });

    function doSearch() {
        const search = $('#business-search');
        let serialized = search.find('input:not([type="checkbox"])').serialize();
        const paged = $('.business-list').data('current-page');

        const businessArray = [];
        const accessibilityArray = [];
        let termValue = '';
        search.find('input[type="checkbox"]:checked').each(function() {
            if (this.value !== 'on') { // 'all' selectors
                termValue = $(this).data('category');
                if (termValue === 'business-category') {
                    businessArray.push(this.value);
                }
                if (termValue === 'accessibility-category') {
                    accessibilityArray.push(this.value);
                }
            }
        });

        serialized += `&business=${businessArray.join(',')}&accessibility=${accessibilityArray}&paged=${paged}`;

        $.ajax({
            url: ajaxurl, // eslint-disable-line
            data: serialized,
            type: search.attr('method'),
            success: data => {
                $('#business-results').html(data);

                const gridBtn = $('a[data-type="grid"]');
                if ($(gridBtn).hasClass('active')) {
                    $('.business__item').removeClass('long')
                        .addClass('grid');
                }
                bindPagination(); // eslint-disable-line
            }
        });
    }

    $('#searchBtn').click(e => {
        e.preventDefault();
        $('.business-list').data('current-page', 1);
        doSearch();
    });

    $('input[name="business-type"]').change(() => {
        doSearch();
    });

    $('.business-filter').change(function() {
        if ($(this).attr('id')
            .endsWith('-all')) {
            const checked = $(this).prop('checked');
            $(this).closest('.business-directory__filter-section')
                .find('input[type="checkbox"]')
                .prop('checked', checked);
        }
        doSearch();
        return false;
    });

    const bindPagination = () => {
        $('.business-list .nav-links a').each((_index, val) => {
            $(val).on('click', e => {
                e.preventDefault();
                let pageNumber = $('.business-list').data('current-page');
                console.log(pageNumber);
                if ($(val).hasClass('next')) {
                    pageNumber++;
                } else if ($(val).hasClass('prev')) {
                    pageNumber--;
                } else {
                    pageNumber = $(val).html();
                }
                $('.business-list').data('current-page', pageNumber);
                doSearch();
                const position = $('.business-banner').offset().top - 100; //100 to compensate for ribbon overflow
                $('body, html').animate({ scrollTop: position });
            });
        });
    };
    bindPagination();
});
