<?php

namespace Blue2\Scruffy\Controllers;

class FormController
{
    private $trail;

    public function __construct()
    {
        $this->registerFilters();
        $this->registerActions();
        add_shortcode('acfBusinessManagementForm', [$this, 'acfBusinessManagementForm']);
    }

    public function registerFilters()
    {
        add_filter('acf/load_field/name=business_category', [$this,'acfLoadBusinessCategories']);
        add_filter('acf/load_field/name=accessibility_category', [$this,'acfLoadAccessibilityCategories']);
    }

    public function registerActions()
    {
        add_action('wp_head', [$this, 'addAcfFormHead'], 7);
        add_action('acf/submit_form', [$this, 'saveBusinessForm']);
    }

    public function addAcfFormHead()
    {
        global $post;

        if (!empty($post) && has_shortcode($post->post_content, 'acfBusinessManagementForm')) {
            acf_form_head();
        }
    }

    public function acfBusinessManagementForm($attributes)
    {
        $shortcodeAttributes = shortcode_atts([
            'field_group' => '',
        ], $attributes);
        $form = '';
        if (!empty($shortcodeAttributes['field_group'])) {
            $options = [
                'uploader' => 'basic',
                'field_groups' => [intval($shortcodeAttributes['field_group'])],
                'html_submit_button'  => '<input type="submit" class="acf-button btn btn-primary custom-submit-acf" value="Submit" />',
                'updated_message' => __("<span class='message-form-updated'>Thank you for your request. An admin must review your submission before it is published.</span>", 'acf'),
            ];
            ob_start();
            acf_form($options);
            $form = ob_get_contents();
            ob_end_clean();
        }
        return $form;
    }

    public function saveBusinessForm($form)
    {
        $post_id = $form["field_groups"][0];

        $businessName = get_field_object('field_60000e2097962', $post_id);
        $businessEmail = get_field_object('field_60000e3897963', $post_id);
        $businessPhone = get_field_object('field_60000e4397964', $post_id);
        $featuredImage = get_field_object('field_6000100c9796f', $post_id);
        $businessDescription = get_field_object('field_60000e6397965', $post_id);
        $businessSummary = get_field_object('field_60000e7397966', $post_id);
        $accessibilityDescription = get_field_object('field_60001c9415850', $post_id);
        $openingTimes = get_field_object('field_6000111c7af6f', $post_id);
        $businessCategory = get_field_object('field_60000f0f97967', $post_id);
        $accessibilityCategory = get_field_object('field_60000f2497968', $post_id);
        $locationField = get_field_object('field_600011037af6e', $post_id);
        $businessWebsite = get_field_object('field_60000fbd9796a', $post_id);
        $facebook = get_field_object('field_60000fcb9796b', $post_id);
        $twitter = get_field_object('field_60000fd19796c', $post_id);
        $instagram = get_field_object('field_60000feb9796d', $post_id);
        $linkedIn = get_field_object('field_60000ff39796e', $post_id);
        $businessType = get_field_object('field_60000f4a97969', $post_id);

        $businessTitle = $_POST['acf'][$businessName['key']];
        $businessContent = $_POST['acf'][$businessDescription['key']];

        $postArg = [
            "post_type" => "business",
            "post_status" => "draft",
            "post_title" => $businessTitle,
            "post_content" => $businessContent
        ];

        $newBusinessIDs = wp_insert_post($postArg);

        $externalLinksKey = "field_5c128698ed619";
        $externalLinks = [
            "website" => $_POST['acf'][$businessWebsite['key']],
            "facebook" => $_POST['acf'][$facebook['key']],
            "twitter" => $_POST['acf'][$twitter['key']],
            "instagram" => $_POST['acf'][$instagram['key']],
            "linkedin" => $_POST['acf'][$linkedIn['key']]
        ];


        update_post_meta($newBusinessIDs, '_thumbnail_id', $_POST['acf'][$featuredImage['key']]);
        update_field( $externalLinksKey, $externalLinks, $newBusinessIDs );
        update_field("email", $_POST['acf'][$businessEmail['key']], $newBusinessIDs);
        update_field("telephone", $_POST['acf'][$businessPhone['key']], $newBusinessIDs);
        update_field("location", $_POST['acf'][$locationField['key']], $newBusinessIDs);
        update_field("summary", $_POST['acf'][$businessSummary['key']], $newBusinessIDs);
        update_field("business_type", $_POST['acf'][$businessType['key']], $newBusinessIDs);
        update_field("accessibility_description", $_POST['acf'][$accessibilityDescription['key']], $newBusinessIDs);
        update_field("opening_times", $_POST['acf'][$openingTimes['key']], $newBusinessIDs);

        $businessSlugs = self::getCategorySlugs($_POST['acf'][$businessCategory['key']], 'business-category');
        $accessibilitySlugs = self::getCategorySlugs( $_POST['acf'][$accessibilityCategory['key']], 'accessibility-category');

        wp_set_object_terms($newBusinessIDs, $businessSlugs, 'business-category');
        wp_set_object_terms($newBusinessIDs, $accessibilitySlugs, 'accessibility-category');

        $this->emailAdminBusiness($businessTitle);
        $this->emailBusinessSubmitter($_POST['acf'][$businessEmail['key']]);
        $this->deleteFormPostData(get_the_id());
    }

    public static function getCategorySlugs($keyData, $category) {
        $slugs = [];
        if($keyData) {
            foreach ($keyData as $id) {
                $termObject = get_term_by('id', $id, $category);
                $slugs[] = $termObject->slug;
            }
        }
        return $slugs;
    }

    public static function deleteFormPostData($id) {
        delete_post_meta($id, 'business_name');
        delete_post_meta($id, 'email');
        delete_post_meta($id, 'telephone');
        delete_post_meta($id, 'full_description');
        delete_post_meta($id, 'featured_image');
        delete_post_meta($id, 'summary');
        delete_post_meta($id, 'opening_times');
        delete_post_meta($id, 'accessibility_description');
        delete_post_meta($id, 'business_type');
        delete_post_meta($id, 'location');
        delete_post_meta($id, 'website_address');
        delete_post_meta($id, 'facebook');
        delete_post_meta($id, 'twitter');
        delete_post_meta($id, 'instagram');
        delete_post_meta($id, 'linkedin');

        delete_post_meta($id, 'business_category');
        delete_post_meta($id, 'accessibility_category');
        wp_set_object_terms($id, [], 'business-category');
        wp_set_object_terms($id, [], 'accessibility-category');
    }


    public static function emailAdminBusiness($businessTitle)
    {
        $to = get_field("notification_email", "option");
        $subject = 'A new business request as been sent';
        $body = '<p>A new business submission has been created for - <strong>' . $businessTitle . '</strong></p>';
        $headers = "Content-type: text/html; charset=\"UTF-8\" \r\n";
        wp_mail($to, $subject, $body, $headers);
    }

    public static function emailBusinessSubmitter($businessEmail)
    {
        $to = $businessEmail;
        $subject = 'Thank you for your business submission';
        $body = '<p>Thank you for submitting your business to the Buy Angus Directory.  A site administrator will contact you once the submission has been approved.</p>';
        $headers = "Content-type: text/html; charset=\"UTF-8\" \r\n";
        wp_mail($to, $subject, $body, $headers);
    }

    function acfLoadBusinessCategories( $field ) {
        $field['choices'] = [];

        $choices = get_terms('business-category', ['hide_empty' => false]);

        if( is_array($choices) ) {
            foreach( $choices as $choice ) {
                if($choice->parent > 0){
                    $field['choices'][ $choice->slug ] = $choice->name;
                }
            }
        }
        return $field;
    }

    function acfLoadAccessibilityCategories( $field ) {
        $field['choices'] = [];

        $choices = get_terms('accessibility-category', ['hide_empty' => false]);

        if( is_array($choices) ) {
            foreach( $choices as $choice ) {
                if($choice->parent > 0){
                    $field['choices'][ $choice->slug ] = $choice->name;
                }
            }
        }
        return $field;
    }
}
