<?php
namespace Blue2\Scruffy;

use Blue2\Scruffy\Controllers\BusinessController;
use Blue2\Scruffy\Controllers\FormController;

class Site extends \Blue2\Common\Site
{
    public function __construct()
    {
        parent::__construct();

        add_action('after_setup_theme', [$this, 'registerMenus']);
        add_filter('excerpt_more', [$this, 'tidyExcerpt']);

        $this->registerShortCodes();
        $this->registerFilters();
        $this->registerActions();
        $this->setupControllers();
    }

    public function registerMenus()
    {
        register_nav_menus([
            'main_menu' => 'Main Menu',
            'footer_menu' => 'Footer Menu',
            'secondary_footer_menu' => 'Secondary Footer Menu'
        ]);
    }

    public function tidyExcerpt()
    {
        return '...';
    }

    private function registerShortCodes()
    {
        // Empty
    }

    private function registerFilters(){
        add_filter('acf/fields/google_map/api', [$this, 'acfApiKey']);
        add_filter('wp_enqueue_scripts', [$this, 'enqueueScripts']);
    }

    private function registerActions() {
        add_action('init', [$this, 'registerPostTypes']);
    }

    private function setupControllers(){
        new BusinessController();
        new FormController();
    }

    public function registerPostTypes()
    {
        Post\Business::registerPostType();
    }

    public function acfApiKey($api)
    {
        $api['key'] = 'AIzaSyAIpS0J2j_IXVl5OU7af1j-tOvSE7gc9G4';
        return $api;
    }

    public function enqueueScripts()
    {
        if (is_page_template('template-contact.php') || is_singular('business')) {
            wp_enqueue_script('google-maps', '//maps.googleapis.com/maps/api/js?key=AIzaSyAIpS0J2j_IXVl5OU7af1j-tOvSE7gc9G4', ['jquery'], null, true);
        }
    }

}
