<?php
$location = get_field('location');
$telephone = get_field('telephone');
$socialMedia = get_field('social_media');
$defaultImage = get_template_directory_uri() . '/dist/images/logo.png';
$imageClass = has_post_thumbnail() ? 'featured-image-set' : 'default-logo';
$openingTimes = get_field('opening_times');
$gallery = get_field('gallery');
?>


<div class="custom-business-single">
    <div class="business-banner">
        <div class="custom-container">
            <?php if ( function_exists('yoast_breadcrumb') ) {
                yoast_breadcrumb( '<div class="custom-breadcrumbs"><p id="breadcrumbs">','</p></div>' );
            } ?>
            <h1><?php the_title(); ?></h1>
        </div>
    </div>

    <div class="main-section">
        <div class="container-fluid">
            <div class="custom-container">
                <div class="row">
                    <div class="col-lg-8">
                        <div class="content-section">
                            <div class="gallery">
                                <div class="swiper-container business-gallery">
                                    <div class="swiper-wrapper">
                                        <?php
                                        if(get_the_post_thumbnail()) { ?>
                                            <div class="swiper-slide">
                                                <div class="business-single-gallery-slide">
                                                    <a href="<?php the_post_thumbnail_url(); ?>" class="image-link">
                                                        <img src="<?php the_post_thumbnail_url(); ?>" alt="<?php the_title(); ?>">
                                                    </a>
                                                </div>
                                            </div>
                                        <?php }
                                        if($gallery) {
                                            $size = 'full';
                                            foreach ($gallery as $image) { ?>
                                                <div class="swiper-slide">
                                                    <div class="business-single-gallery-slide">
                                                        <a href="<?= $image['url'] ?>" class="image-link">
                                                            <img src="<?= $image['url'] ?>" alt="<?= $image['alt']; ?>">
                                                        </a>
                                                    </div>
                                                </div>
                                            <?php }
                                        } ?>
                                    </div>
                                </div>
                            </div>

                            <div class="description"><?php the_content(); ?></div>
                            <?php if ($socialMedia['website']) {?><div class="website">Website: <a href="<?= $socialMedia['website']; ?>" class="site" target="_blank"><?= $socialMedia['website']; ?></a></div><?php }?>

                            <div class="social">
                                <?php if ($socialMedia['facebook']) {?>
                                    <a href="<?= $socialMedia['facebook']; ?>" target="_blank">
                                        <span class="fa-stack">
                                          <i class="fas fa-circle fa-stack-2x"></i>
                                          <i class="fab fa-facebook-f fa-stack-1x fa-inverse"></i>
                                        </span>
                                    </a>
                                <?php }?>
                                <?php if ($socialMedia['twitter']) {?>
                                    <a href="<?= $socialMedia['twitter']; ?>" target="_blank">
                                        <span class="fa-stack">
                                          <i class="fas fa-circle fa-stack-2x"></i>
                                          <i class="fab fa-twitter fa-stack-1x fa-inverse"></i>
                                        </span>
                                    </a>
                                <?php } ?>
                                <?php if ($socialMedia['instagram']) {?>
                                    <a href="<?= $socialMedia['instagram']; ?>" target="_blank">
                                        <span class="fa-stack">
                                          <i class="fas fa-circle fa-stack-2x"></i>
                                          <i class="fab fa-instagram fa-stack-1x fa-inverse"></i>
                                        </span>
                                    </a>
                                <?php }?>
                                <?php if ($socialMedia['linkedin']) {?>
                                    <a href="<?= $socialMedia['linkedin']; ?>" target="_blank">
                                        <span class="fa-stack">
                                          <i class="fas fa-circle fa-stack-2x"></i>
                                          <i class="fab fa-linkedin-in fa-stack-1x fa-inverse"></i>
                                        </span>
                                    </a>
                                <?php }?>
                            </div>

                            <div class="row">
                                <?php
                                $accessibilityOptions = get_the_terms(get_the_id(), 'accessibility-category');
                                if($accessibilityOptions) { ?>
                                    <div class="col-lg-6">
                                        <div class="accessibility">
                                            <h3>Accessibility Information</h3>
                                            <?php if(get_field('accessibility_description')) { ?><div class="accessibility-description"><?php the_field('accessibility_description') ?></div><?php } ?>
                                            <ul>
                                                <?php foreach($accessibilityOptions as $option) { ?>
                                                    <li><?= $option->name; ?></li>
                                                <?php } ?>
                                            </ul>
                                        </div>
                                    </div>
                                <?php }
                                if($openingTimes) { ?>
                                    <div class="col-lg-6">
                                        <div class="opening-times">
                                            <h3>Opening Times</h3>
                                            <?= $openingTimes; ?>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>


                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div id="map" data-lat="<?= $location['lat'] ?>" data-lng="<?= $location['lng']; ?>" data-zoom="<?= $location['zoom']; ?>"></div>
                    </div>
                </div>







            </div>
        </div>

    </div>
</div>
