<?php
$map = get_field('company_location', 'option');
$phone = get_field('contact_phone_number', 'option');
$emailAddress = get_field('contact_email_address', 'option');

?>

<div class="custom-contact-template">
    <div class="custom-container">
        <div class="row row-eq-height">
            <div class="col-lg-6">
                <div class="contact-block">
                    <h1><?php the_title(); ?></h1>
                    <?php the_content(); ?>

                    <ul class="contact-items">
                        <?php if($emailAddress) { ?><li>Email: <a href="mailto:<?= $emailAddress; ?>"><?= $emailAddress; ?></a></li><?php } ?>
                        <?php if($phone) { ?><li>Phone: <a href="tel:<?= $phone; ?>"><?= $phone; ?></a></li><?php } ?>
                    </ul>

                    <div class="contact-form">
                        <?= do_shortcode(get_field('contact_form_shortcode')); ?>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="map-block">
                    <div id="map" data-lat="<?= $map['lat'] ?>" data-lng="<?= $map['lng']; ?>" data-zoom="<?= $map['zoom']; ?>"></div>
                </div>
            </div>
        </div>
    </div>

</div>