<?php
$title = get_sub_field('title');
$description = get_sub_field('description');
?>

<div class="flexible-section business-section">
    <div class="container-fluid">
        <?php if($title) { ?><h2><?= $title; ?></h2><?php } ?>
        <div class="bio-holder">
            <div class="top-holder">
                <?php if($description){ ?>
                    <div class="row">
                        <div class="offset-lg-3 col-lg-6">
                            <div class="content-section text-center">
                                <?= $description; ?>
                            </div>
                        </div>
                    </div>
                <?php } ?>
                <?php
                $args = [
                    'post_type' => 'business',
                    'post_status' => 'publish',
                    'posts_per_page' => 20
                ];
                $businessQuery = new WP_Query($args);
                if ($businessQuery->have_posts()) { ?>
                    <div class="bio-output">
                        <div class="swiper-container bio-swiper">

                            <div class="swiper-button-next"></div>
                            <div class="swiper-button-prev"></div>

                            <div class="swiper-wrapper">
                                <?php while ( $businessQuery->have_posts() ) {
                                    $businessQuery->the_post(); ?>
                                    <div class="swiper-slide">
                                        <div class="single-bio">
                                            <div class="image-top">
                                                <a href="<?php the_permalink(); ?>">
                                                    <img src="<?php the_post_thumbnail_url(); ?>" alt="<?php the_title(); ?>"/>
                                                </a>
                                            </div>
                                            <div class="content-bottom">
                                                <h4><?php the_title(); ?></h4>
                                                <div class="description"><?php the_field('summary'); ?></div>
                                                <div class="cta"><a href="<?php the_permalink(); ?>">View Business</a></div>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                            <div class="swiper-pagination"></div>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
</div>