$(window).load(() => {
    $('a.business-directory__filter-section__title').click(function() {
        $(this).parent('.business-directory__filter-section__inner')
            .toggleClass('active');
    });

    $('#business-grid-type > a').click(function(e) {
        if (!$(this).hasClass('active')) {
            $(this).siblings()
                .each((index, obj) => {
                    $('.business__item').removeClass($(obj).data('type'));
                    $(obj).removeClass('active');
                });

            const type = $(this).data('type');
            $('.business__item').toggleClass(type);
            $(this).toggleClass('active');
        }

        e.preventDefault();
    });

    const $loading = $('#business-loading').hide();
    $(document).ajaxStart(() => {
        $loading.show();
    })
        .ajaxStop(() => {
            $loading.hide();
        });

    function doSearch() {
        const search = $('#business-search');
        let serialized = search.find('input:not([type="checkbox"])').serialize();

        const checkboxArray = [];
        search.find('input[type="checkbox"]:checked').each(function() {
            if (this.value !== 'on') { // 'all' selectors
                checkboxArray.push(this.value);
            }
        });

        serialized += `&term=${checkboxArray.join(',')}`;

        $.ajax({
            url: ajaxurl, // eslint-disable-line
            data: serialized,
            type: search.attr('method'),
            // beforeSend: function (xhr) {
            // },
            success: data => {
                $('#business-results').html(data);
                // $('.page').val(1);

                const gridBtn = $('a[data-type="grid"]');
                if ($(gridBtn).hasClass('active')) {
                    $('.business__item').removeClass('long')
                        .addClass('grid');
                }
            }
        });
    }

    $('#searchBtn').click(e => {
        e.preventDefault();
        doSearch();
    });

    $('input[name="business-type"]').change(() => {
        doSearch();
    });

    $('.business-filter').change(function() {
        // $('.loadmore').show();
        // $('.end').remove();
        // $('.page').val(0);

        if ($(this).attr('id')
            .endsWith('-all')) {
            const checked = $(this).prop('checked');
            $(this).closest('.business-directory__filter-section')
                .find('input[type="checkbox"]')
                .prop('checked', checked);
        }

        doSearch();

        return false;
    });
});
