<?php

$siteLogo = get_field('company_logo', 'option');

?>

<nav class="header-nav">


    <div class="image-holder">
    <img src="<?= get_template_directory_uri() . '/dist/images/people-1.png'; ?>" class="header-img primary">
    </div>

    <div class="main-section">

        <div class="toggler-holder">
            <a class="navbar-brand" href="<?= esc_url(home_url('/')); ?>">
                <img src="<?= $siteLogo['url'];  ?>" alt="<?php bloginfo('name'); ?>" />
            </a>
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <i class="far fa-bars"></i>
            </button>
        </div>

        <div class="collapse navbar-collapse" id="navbarSupportedContent">
            <?php
            if (has_nav_menu('main_menu')) {
                wp_nav_menu(['theme_location' => 'main_menu', 'menu_class' => 'navigation']);
            }
            ?>

            <ul class="contact">
                <?php if (get_field('contact_phone_number', 'option')) { ?>
                    <li><a href="tel:<?php the_field('contact_phone_number', 'option'); ?>"><i class="far fa-phone"></i> <?php the_field('contact_phone_number', 'option'); ?></a></li>
                <?php } ?>
                <?php if (get_field('contact_email_address', 'option')) { ?>
                    <li><a href="mailto:<?php the_field('contact_email_address', 'option'); ?>"><i class="far fa-envelope-open"></i> <?php the_field('contact_email_address', 'option'); ?></a></li>
                <?php } ?>
            </ul>
        </div>
    </div>

    <div class="image-holder">
    <img src="<?= get_template_directory_uri() . '/dist/images/people-2.png'; ?>" class="header-img secondary">
    </div>

</nav>