import Swiper from 'swiper';

const common = () => {
    if ($('.bio-swiper').length) {
        new Swiper('.bio-swiper', {
            autoplay: {
                delay: 3000,
            },
            loop: true,
            breakpoints: {
                992: {
                    slidesPerView: 2,
                    spaceBetween: 25
                },
                1500: {
                    slidesPerView: 3,
                    spaceBetween: 25
                }
            },
            navigation: {
                nextEl: '.swiper-button-next',
                prevEl: '.swiper-button-prev',
            },
            pagination: {
                el: '.swiper-pagination',
                clickable: true
            },
        });
    }
};

export default common;
