<?php
namespace Blue2\Scruffy;

use Blue2\Scruffy\Controllers\BusinessController;

class Site extends \Blue2\Common\Site
{
    public function __construct()
    {
        parent::__construct();

        add_action('after_setup_theme', [$this, 'registerMenus']);
        add_filter('excerpt_more', [$this, 'tidyExcerpt']);

        $this->registerShortCodes();
        $this->registerFilters();
        $this->registerActions();
        $this->setupControllers();
    }

    public function registerMenus()
    {
        register_nav_menus([
            'main_menu' => 'Main Menu',
            'footer_menu' => 'Footer Menu'
        ]);
    }

    public function tidyExcerpt()
    {
        return ' &hellip; <a href="' . get_permalink() . '">Continued</a>';
    }

    private function registerShortCodes()
    {
        // Empty
    }

    private function registerFilters(){
        add_filter('acf/fields/google_map/api', [$this, 'acfApiKey']);
    }

    private function registerActions() {
        add_action('init', [$this, 'registerPostTypes']);
    }

    private function setupControllers(){
        new BusinessController();
    }

    public function registerPostTypes()
    {
        Post\Event::registerPostType();
        Post\Business::registerPostType();
    }

    public function acfApiKey($api)
    {
        $api['key'] = 'AIzaSyAIpS0J2j_IXVl5OU7af1j-tOvSE7gc9G4';
        return $api;
    }

}