import Swiper from 'swiper';

const common = () => {
    if ($('.bio-swiper').length) {
        new Swiper('.bio-swiper', {
            autoplay: {
                delay: 3000,
            },
            loop: true,
            breakpoints: {
                992: {
                    slidesPerView: 2,
                    spaceBetween: 25
                },
                1500: {
                    slidesPerView: 3,
                    spaceBetween: 25
                }
            },
            navigation: {
                nextEl: '.swiper-button-next',
                prevEl: '.swiper-button-prev',
            },
            pagination: {
                el: '.swiper-pagination',
                clickable: true
            },
        });
    }

    if ($('#map').length) {
        const google = window.google;
        const location = $('#map');
        const mapLng = location.data('lng');
        const mapLat = location.data('lat');
        const mapZoom = location.data('zoom');
        const mapCenter = { lat: mapLat, lng: mapLng };
        const map = new google.maps.Map(document.getElementById('map'), {
            zoom: mapZoom,
            center: mapCenter,
            scrollWheel: false,
            streetViewControl: false,
        });

        if ($('.custom-business-single').length) {
            new google.maps.Marker({
                position: mapCenter,
                map,
            });
        }
    }
};

export default common;
