<?php
$location = get_field('location');
$telephone = get_field('telephone');
$socialMedia = get_field('social_media');
$defaultImage = get_template_directory_uri() . '/dist/images/logo.png';
$imageClass = has_post_thumbnail() ? 'featured-image-set' : 'default-logo';
?>
<div class="business__item long">

        <div class="business__image-outer">
            <?php if (get_field('featured')) {?>
                <span class="business__featured">Featured</span>
            <?php } ?>
            <div class="business__image-wrap <?= $imageClass; ?>">
                <?php if (has_post_thumbnail()) {
                    the_post_thumbnail('tile', array('class' => 'business__image', 'alt' => get_the_post_thumbnail_caption()));
                } else { ?>
                    <img src="<?= $defaultImage ?>" class="business__image" alt="Default BuyAngus logo">
                <?php } ?>
            </div>
        </div>
        <div class="business__content">
            <div class="business__title">
                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
            </div>
            <div class="business__text">
                <?= get_field('summary'); ?>
            </div>
            <div class="business__details">
                <?php if ($location) {?>
                    <span><i class="fas fa-map-marker-alt"></i><span><?= $location['address']; ?></span></span>
                <?php }?>
            </div>
            <div class="business__links">

                <div class="buttons">
                    <?php if ($socialMedia['website']) {?><a href="<?= $socialMedia['website']; ?>" class="site" target="_blank">Visit site</a><?php }?>
                    <a href="<?php the_permalink(); ?>" class="site">Full Listing</a>
                </div>


                <div class="social">
                    <?php if ($socialMedia['facebook']) {?>
                        <a href="<?= $socialMedia['facebook']; ?>" target="_blank">
                        <span class="fa-stack">
                          <i class="fas fa-circle fa-stack-2x"></i>
                          <i class="fab fa-facebook-f fa-stack-1x fa-inverse"></i>
                        </span>
                        </a>
                    <?php }?>
                    <?php if ($socialMedia['twitter']) {?>
                        <a href="<?= $socialMedia['twitter']; ?>" target="_blank">
                        <span class="fa-stack">
                          <i class="fas fa-circle fa-stack-2x"></i>
                          <i class="fab fa-twitter fa-stack-1x fa-inverse"></i>
                        </span>
                        </a>
                    <?php } ?>
                    <?php if ($socialMedia['instagram']) {?>
                        <a href="<?= $socialMedia['instagram']; ?>" target="_blank">
                        <span class="fa-stack">
                          <i class="fas fa-circle fa-stack-2x"></i>
                          <i class="fab fa-instagram fa-stack-1x fa-inverse"></i>
                        </span>
                        </a>
                    <?php }?>
                    <?php if ($socialMedia['linkedin']) {?>
                        <a href="<?= $socialMedia['linkedin']; ?>" target="_blank">
                        <span class="fa-stack">
                          <i class="fas fa-circle fa-stack-2x"></i>
                          <i class="fab fa-linkedin-in fa-stack-1x fa-inverse"></i>
                        </span>
                        </a>
                    <?php }?>
                </div>
            </div>
        </div>
</div>