<?php

$defaultImage = get_template_directory_uri() . '/dist/images/logo.png';
$image = get_the_post_thumbnail_url() ?: $defaultImage;
$imageClass = has_post_thumbnail() ? 'featured-image-set' : 'default-logo';

?>

<div class="col-md-6 col-xl-4 spotlight-col">
    <div class="spotlight-inner">
        <div class="image-section <?= $imageClass; ?>">
            <a href="<?php the_permalink(); ?>">
                <img src="<?= $image; ?>" alt="<?php the_title(); ?>"/>
            </a>
        </div>
        <div class="content-section">
            <h2><?php the_title(); ?></h2>
            <div class="description"><?php the_excerpt(); ?></div>
            <a href="<?php the_permalink(); ?>" class="spotlight-button">View Spotlight</a>
        </div>
    </div>
</div>
