<?php
$videoType = get_sub_field('video_type');
$title = get_sub_field('video_title');
$description = get_sub_field('video_description');
?>
<div class="flexible-section video-section">
    <div class="custom-container text-center">

        <?php if($title) { ?><h3 class="video-title"><?= $title; ?></h3><?php } ?>
        <?php if($description) { ?><div class="video-description"><?= $description; ?></div><?php } ?>

        <?php if($videoType == 'custom') {
            $video = get_sub_field('video_custom'); ?>
            <div class="video-holder">
                <video controls>
                    <source src="<?= $video['url']; ?>" type="video/mp4">
                </video>
            </div>
        <?php } else {
            $iframe = get_sub_field('video_embed');
            preg_match('/src="(.+?)"/', $iframe, $matches);
            $src = $matches[1];
            $params = [
                'controls'  => 1,
                'hd'        => 1,
                'autohide'  => 1
            ];
            $newSrc = add_query_arg($params, $src);
            $iframe = str_replace($src, $newSrc, $iframe);
            $attributes = 'frameborder="0"';
            $iframe = str_replace('></iframe>', ' ' . $attributes . '></iframe>', $iframe);
            ?>

            <div class="iframe-holder">
                <div class="iframe-container">
                    <?= $iframe; ?>
                </div>
            </div>


        <?php } ?>
    </div>
</div>