<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://blue2.co.uk
 * @since      1.0.0
 *
 * @package    Blue2_Borealis_Api
 * @subpackage Blue2_Borealis_Api/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Blue2_Borealis_Api
 * @subpackage Blue2_Borealis_Api/admin
 * @author     Blue2 <ross@blue2.co.uk>
 */
class Blue2_Borealis_Api_Admin
{

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct($plugin_name, $version)
	{

		$this->plugin_name = $plugin_name;
		$this->version = $version;
	}

	public function admin_notice()
	{
		if (!defined('BLUE2_BOREALIS_API_COMPANY_NAME') || !defined('BLUE2_BOREALIS_API_INSTANCE') || !defined('BLUE2_BOREALIS_API_KEY')) {
			echo '<div class="notice notice-error is-dismissible">
				<p>Blue2 Borealis API is not configured. Please enter your company name, instance and API key in the config file.</p>
			</div>';
		}
	}
}
