# Blue2 Borealis API Integration

This project is a WordPress plugin named "Blue2 Borealis API Integration". The plugin integrates the Borealis API into WordPress, specifically designed to work with ContactForm7 forms and Ninja Forms. The plugin allows users to send form data to the Borealis API, which is used for stakeholder engagement and management.

## Key Features:

1. API Integration: The plugin communicates with the Borealis API to manage stakeholders, organisations, communications, and engagement plans.
2. Form Integration: It integrates with Ninja Forms and ContactForm7 to send form data to the Borealis API.
3. Admin Notices: Displays admin notices if the required configuration variables are not set.
4. Hooks and Actions: Registers hooks and actions to handle form submissions and other events.

## Main Components:

1. Core Plugin Class:
    * `Blue2_Borealis_Api`: Defines the core functionality, including loading dependencies, defining hooks, and running the plugin.
2. Admin Functionality:
    * `Blue2_Borealis_Api_Admin`: Handles admin-specific functionality, such as displaying notices.
3. Public Functionality:
    * `Blue2_Borealis_Api_Public`: Handles public-facing functionality, such as processing form data and sending it to the Borealis API.
4. Service Class:
    * `Blue2_Borealis_Api_Service`: Manages API requests to the Borealis API, including checking if an individual exists, creating and updating individuals, and managing organisations and communications.
5. Loader Class:
    * `Blue2_Borealis_Api_Loader`: Registers all actions and filters for the plugin.

## Configuration:

The plugin requires the following constants to be defined in the `wp-config.php` file:

* `BLUE2_BOREALIS_API_COMPANY_NAME`
* `BLUE2_BOREALIS_API_INSTANCE`
* `BLUE2_BOREALIS_API_KEY`

## Integrate with Ninja Forms
This plugin is designed to integrate with Ninja Form actions. We have two available hooks:

 - `blue2_send_project_updates_form_data_to_borealis`
 - `blue2_send_supplier_registration_form_data_to_borealis`

To add one of these hooks to a form, do the following:

 1. In WP Admin, open the settings of the form
 2. Go to 'Emails & Actions'
 3. Click 'Add new action'
 4. Choose 'WP Hook'
 5. Add one of the above hooks into the 'HOOK TAG' field
 6. Click 'Done'

This hook should now be called on form submissions!

## Uninstallation:

The plugin includes an uninstallation script (`uninstall.php`) that ensures the plugin is uninstalled correctly when triggered by WordPress.
