<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://blue2.co.uk
 * @since             1.0.0
 * @package           Blue2_Borealis_Api
 *
 * @wordpress-plugin
 * Plugin Name:       Borealis API
 * Plugin URI:        https://blue2.co.uk
 * Description:       This plugin integrates the Borealis API into the ContactForm7 forms
 * Version:           1.0.0
 * Author:            Blue2 Digital Ltd
 * Author URI:        https://blue2.co.uk/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       blue2-borealis-api
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define('BLUE2_BOREALIS_API_VERSION', '1.0.0');

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path(__FILE__) . 'includes/class-blue2-borealis-api.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_blue2_borealis_api()
{
	$plugin = new Blue2_Borealis_Api();
	$plugin->run();
}
run_blue2_borealis_api();
