<?php
$bannerImages = get_sub_field('banner_images');
$count = 0;
if($bannerImages) { ?>
    <section class="custom-flexible-section hero-project">

        <div class="main-swiper">
            <div class="swiper-wrapper">
                <?php foreach($bannerImages as $image) { ?>
                    <div class="swiper-slide">
                        <img src="<?= $image['image']['url']; ?>" alt="<?= $image['image']['alt']; ?>" />
                        <div class="expand">
                            <a href="<?= $image['image']['url']; ?>" target="_blank"><span class="fal fa-expand-arrows"></span></a>
                        </div>
                    </div>
                <?php } ?>
            </div>
            <div class="swiper-pagination"></div>
        </div>




        <div class="holder">
            <div class="info-wrapper">
                <div class="info-blocks">
                    <div class="info-swiper">
                        <div class="swiper-wrapper">
                            <?php foreach($bannerImages as $image) { $count++; ?>
                                <div class="swiper-slide">
                                    <?php if($image['description']) { ?>
                                        <div class="info-block">
                                            <div class="wrapper">
                                                <div class="number"><?= sprintf("%02d", $count) . '.'; ?></div>
                                                <div class="description"><?= $image['description']; ?></div>
                                            </div>
                                        </div>
                                    <?php } ?>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>

            <div class="thumbnail-wrapper">
                <div class="thumbnail-slides">
                    <div class="thumbnail-swiper">
                        <div class="swiper-wrapper">
                            <?php foreach($bannerImages as $image) { ?>
                                <div class="swiper-slide">
                                    <div class="image-wrapper">
                                        <img src="<?= $image['image']['url']; ?>" alt="<?= $image['image']['alt']; ?>" />
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>


    </section>
<?php } ?>
