<?php
$newsSlogan = get_field('news_archive_slogan', 'option') ?: 'News';
if(!is_category()){
    $newsTitle = get_field('news_archive_title', 'option') ?: 'Latest News';
} else {
    $taxonomy = get_queried_object();
    $newsTitle = get_field('news_archive_title', 'option') ?: 'Latest News - ' . $taxonomy->name;
}
?>

<div class="custom-news-archive">
    <div class="contain">

        <div class="title-holder">
            <div class="slogan"><?= $newsSlogan; ?></div>
            <div class="company">arktx</div>
            <h1><?= $newsTitle; ?></h1>
        </div>

        <div class="news-output">
            <div class="row row-eq-height">
                <?php Blue2\Scruffy\Utils::archiveLoop(); ?>
            </div>
        </div>

        <div class="custom-pagination">
            <?php
            the_posts_pagination([
                'mid_size' => 2,
                'prev_text' => __('<', 'textdomain'),
                'next_text' => __('>', 'textdomain'),
                'before_page_number' => '<span class="meta-nav screen-reader-text">' . __('', '') . ' </span>',
            ]); ?>
        </div>

    </div>
</div>



