import { fontawesome, throttle } from './utils';
import Swiper from 'swiper';

const common = () => {
    fontawesome();
    if ($('.quote-swiper').length) {
        new Swiper('.quote-swiper', {
            watchOverflow: true,
            spaceBetween: 0,
            slidesPerView: 1,
            loop: true,
            pagination: {
                el: '.swiper-pagination',
                clickable: true
            },
        });
    }

    if ($('.hero-project').length) {
        const thumbnails = new Swiper('.thumbnail-swiper', {
            loop: true,
            spaceBetween: 16,
            slidesPerView: 2.75,
            slideToClickedSlide: true,
        });

        const infoBlocks = new Swiper('.info-swiper', {
            loop: true,
            slidesPerView: 1,
            spaceBetween: 32,
            allowTouchMove: false,
            watchSlidesProgress: true,
            slideToClickedSlide: true,
        });

        const mainSwiper = new Swiper('.main-swiper', {
            loop: true,
            spaceBetween: 0,
            slidesPerView: 1,
            allowTouchMove: false,
            slideToClickedSlide: true,
            pagination: {
                el: '.swiper-pagination',
                clickable: true
            },
            thumbs: {
                swiper: thumbnails,
            },
        });

        mainSwiper.on('transitionStart', function() {
            infoBlocks.slideTo(mainSwiper.activeIndex);
        });
    }
};


export default common;
