<?php
$prevPost = get_previous_post();
$nextPost = get_next_post();
$date = get_the_date();
$category = get_the_category();
$otherNewsArgs = [
    'post_type' => 'post',
    'numberposts' => 3,
    'post_status' => 'publish',
    'exclude' => [get_the_id()]
];

$otherPosts = get_posts($otherNewsArgs);
?>
<div class="custom-single-news">
    <div class="contain">

        <div class="title">
            <div class="date"><?= $date; ?> /</div>
            <div class="category"><a href="<?= get_category_link($category[0]->term_id); ?>"><?= $category[0]->name; ?></a></div>
        </div>


        <div class="row">
            <div class="col-md-8">
                <main class="main-col">
                    <?php if(get_the_post_thumbnail_url()) { ?>
                        <div class="image-wrapper">
                            <img src="<?php the_post_thumbnail_url(); ?>" alt="<?php the_title(); ?>">
                        </div>
                    <?php } ?>

                    <h1><?= the_title(); ?></h1>

                    <div class="content">
                        <?php the_content(); ?>
                    </div>

                    <div class="article-nav">
                        <ul>
                            <?php if($prevPost) { ?><li><a href="<?= get_the_permalink($prevPost->ID); ?>"><span class="fas fa-chevron-left"></span> Previous Article</a></li><?php } ?>
                            <?php if($nextPost) { ?><li><a href="<?= get_the_permalink($nextPost->ID); ?>">Next Article <span class="fas fa-chevron-right"></span></a></li><?php } ?>
                        </ul>
                    </div>

                </main>
            </div>
            <div class="col-md-4">
                <aside class="aside-col">

                    <?php if($otherPosts) { ?>
                        <h2>Other News</h2>

                        <div class="other-post-output">
                            <?php foreach($otherPosts as $post) {
                                setup_postdata($post);
                                $imageID = get_post_thumbnail_id();
                                $image = \Blue2\Scruffy\Site::acfImage($imageID, ''); ?>
                                <div class="news-item other-news-item">
                                    <div class="image-wrapper <?= $image['class']; ?>">
                                        <a href="<?php the_permalink(); ?>">
                                            <?= $image['output']; ?>
                                        </a>
                                    </div>
                                    <div class="content-wrapper">
                                        <h2><?php the_title(); ?></h2>
                                        <div class="description">
                                            <?php the_excerpt(); ?>
                                        </div>
                                        <div class="cta">
                                            <a href="<?php the_permalink(); ?>">View Article <span class="fas fa-chevron-right"></span></a>
                                        </div>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>

                    <?php } ?>


                </aside>
            </div>
        </div>
    </div>
</div>
