<?php
$quotes = get_sub_field('quotes');
if($quotes) { ?>
    <section class="custom-flexible-section quotes-section">
        <div class="swiper-container quote-swiper">
            <div class="swiper-wrapper">
                <?php foreach($quotes as $quote) { ?>
                    <div class="swiper-slide">
                        <div class="quote-inner" <?php if($quote['quote_background_image']) { ?>style="background-image:url('<?= $quote['quote_background_image']['url']; ?>')"<?php } ?>>
                            <div class="quote-wrapper">
                                <div class="icon"><span class="far fa-comments"></span></div>
                                <div class="content"><?= $quote['quote_content']; ?></div>
                                <div class="by">
                                    <?php if($quote['quote_by_name']) { ?><div class="name"><?= $quote['quote_by_name']; ?></div><?php } ?>
                                    <?php if($quote['quote_by_company']) { ?><div class="company"><?= $quote['quote_by_company']; ?></div><?php } ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>
            <div class="swiper-pagination"></div>
        </div>
    </section>
<?php } ?>
