<?php
$imageID = get_post_thumbnail_id();
$image = \Blue2\Scruffy\Site::acfImage($imageID, 'team-archive');
$email = get_field('email_address');
$linkedIn = get_field('linkedin');
$position = get_field('position');
$description = get_the_content();

?>
<div class="col-sm-6 col-lg-4 team-col">
    <div class="team-item">
        <div class="image-wrapper <?= $image['class']; ?>">
            <?= $image['output']; ?>
            <?php if($description) { ?>
                <div class="overlay">
                    <div class="wrapper">
                        <div class="description"><?= $description; ?></div>
                        <?php if($linkedIn || $email) { ?>
                            <ul>
                                <?php if($email) { ?>
                                    <li>
                                        <a href="mailto:<?= $email; ?>">
                                        <span class="fa-stack">
                                          <span class="fas fa-circle fa-stack-2x"></span>
                                          <span class="far fa-envelope fa-stack-1x fa-inverse contact-icon"></span>
                                        </span>
                                        </a>
                                    </li>
                                <?php } ?>
                                <?php if($linkedIn) { ?>
                                    <li>
                                        <a href="<?= $linkedIn; ?>" target="_blank">
                                        <span class="fa-stack">
                                          <span class="fas fa-circle fa-stack-2x"></span>
                                          <span class="fab fa-linkedin-in fa-stack-1x fa-inverse contact-icon"></span>
                                        </span>
                                        </a>
                                    </li>
                                <?php } ?>
                            </ul>
                        <?php } ?>
                    </div>
                </div>
            <?php } ?>
        </div>
        <div class="content-wrapper">
            <h2 class="fw-700"><?php the_title(); ?></h2>
            <h3><?= $position; ?></h3>
        </div>
    </div>
</div>
