<?php
$featuredTeam = get_sub_field('featured_team_members');
$teamSlogan = get_field('team_archive_slogan', 'option') ?: 'What we do';
$teamTitle =  get_field('team_archive_title', 'option') ?: 'Projects';
if($featuredTeam) { ?>
    <section class="custom-flexible-section featured-team-section">
        <div class="contain">
            <div class="top-section">
                <div class="title-holder">
                    <div class="slogan"><?= $teamSlogan; ?></div>
                    <div class="company">arktx</div>
                    <h2><?= $teamTitle; ?></h2>
                </div>
                <div class="view-all"><a href="<?= get_permalink( get_option( 'page_for_posts' ) ); ?>">View Everyone <span class="fas fa-chevron-right"></span></a></div>
            </div>
            <div class="team-members">
                <div class="row d-flex justify-content-center">
                    <?php foreach($featuredTeam as $post) {
                        setup_postdata($post);
                        get_template_part('templates/team/content');
                    } wp_reset_postdata(); ?>
                </div>
            </div>
        </div>
    </section>
<?php } ?>
