<?php
$args = [
    'post_type' => 'post',
    'numberposts' => 3,
    'post_status' => 'publish',
];
$news = get_posts($args);

$featuredNews = get_sub_field('featured_news_articles') ?: $news;
if($featuredNews) {
    $newsSlogan = get_field('news_archive_slogan', 'option') ?: 'News';
    $newsTitle = get_field('news_archive_title', 'option') ?: 'Latest News'; ?>
    <section class="custom-flexible-section featured-news-section">
        <div class="contain">
            <div class="top-section">
                <div class="title-holder">
                    <div class="slogan"><?= $newsSlogan; ?></div>
                    <div class="company">arktx</div>
                    <h2><?= $newsTitle; ?></h2>
                </div>
                <div class="view-all"><a href="<?= get_permalink( get_option( 'page_for_posts' ) ); ?>">View All News <span class="fas fa-chevron-right"></span></a></div>
            </div>
            <div class="articles">
                <div class="row d-flex justify-content-center">
                    <?php foreach($featuredNews as $post) {
                        setup_postdata($post);
                        get_template_part('templates/post/content');
                    } wp_reset_postdata(); ?>
                </div>
            </div>
        </div>
    </section>
<?php } ?>
