<?php
$phone = get_field('contact_phone_number', 'option');
$email = get_field('contact_email_address', 'option');
$address = get_field('company_address', 'option');
?>

<footer class="site-footer">
    <div class="contain">
        <div class="top-row">
            <div class="copyright">
                <p>&copy; <span><?php bloginfo('name'); ?></span> <?= date("Y"); ?></p>
            </div>
            <div class="info">
                <ul>
                    <?php if($phone) { ?><li class="phone">Call <a href="tel:<?= $phone; ?>"><?= $phone; ?></a></li><?php } ?>
                    <?php if($phone) { ?><li class="address"><?= $address; ?><?php } ?>
                    <?php if($email) { ?><li class="email"><a href="mailto:<?= $email; ?>"><?= $email; ?></a></li><?php } ?>
                </ul>

            </div>
            <div class="credit">
                <p>Site by <?php echo do_shortcode( '[blue2_logo type="light"]' ); ?></p>
            </div>
        </div>

        <div class="bottom-row">
            <nav class="navigation">
                <?php
                if (has_nav_menu('footer_menu' )) {
                    wp_nav_menu(['theme_location' => 'footer_menu', 'menu_class' => '']);
                }
                ?>
            </nav>
        </div>
    </div>
</footer>
