<?php
$imagesPosition = get_sub_field('image_position');
$primaryImage = get_sub_field('primary_image');
$secondaryImage = get_sub_field('secondary_image');
$slogan = get_sub_field('slogan');
$primaryTitle = get_sub_field('primary_title');
$secondaryTitle = get_sub_field('secondary_title');
$description = get_sub_field('description');
$cta = get_sub_field('cta');

$imageColPosition = $imagesPosition == 'left' ? 'order-1' : 'order-2';
$contentColPosition = $imagesPosition == 'left' ? 'order-2' : 'order-1';

?>

<section class="custom-flexible-section split-section">
    <div class="contain">
        <div class="row row-eq-height d-flex">
            <div class="col-lg-6 image-col <?= $imageColPosition; ?>">
                <div class="image-inner">
                    <div class="primary-image-wrapper">
                        <img src="<?= $primaryImage['url']; ?>">
                    </div>
                    <div class="secondary-image-wrapper">
                        <img src="<?= $secondaryImage['url']; ?>">
                    </div>
                </div>
            </div>
            <div class="col-lg-6 content-col <?= $contentColPosition; ?>">
                <div class="content-inner">
                    <div class="title-holder">
                        <div class="slogan"><?= $slogan; ?></div>
                        <div class="company"><?= $primaryTitle ?: 'arktx'; ?></div>
                        <h2><?= $secondaryTitle; ?></h2>
                    </div>
                    <div class="description"><?= $description; ?></div>
                    <?php if($cta) { ?>
                        <div class="cta">
                            <a href="<?= $cta['url']; ?>" target="<?= $cta['target']; ?>"><?= $cta['title']; ?> <span class="fas fa-chevron-right"></span></a>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
</section>
