<?php
$bannerItems = get_sub_field('banner_items');
$bannerCount = count($bannerItems);
$thumbnailCount = 0;
$mainCount = 0;
$socials = get_field('social_media_channels', 'option');
?>


<section class="custom-flexible-section hero-standard">
    <div class="standard-main-swiper">
        <div class="swiper-wrapper">
            <?php foreach($bannerItems as $item) { $mainCount++;
            $heading = $mainCount == 1 ? 'h1' : 'h2'; ?>
            <div class="swiper-slide">
                <div class="standard-item" style="background-image:url('<?= $item['banner_image']['url']; ?>')">
                    <div class="contain">
                        <div class="inner">
                            <div class="content-wrapper">
                                <div class="label"><?= $item['banner_label']; ?></div>
                                <<?= $heading; ?>><?= $item['banner_title'] ?></<?= $heading; ?>>
                                <?php if($item['banner_cta']) { ?>
                                    <div class="cta"><a href="<?= $item['banner_cta']['url']; ?>"><?= $item['banner_cta']['title']; ?> <span class="fas fa-chevron-right"></a></div>
                                <?php } ?>
                         </div>
                        <div class="count">
                            <div class="current"><?= sprintf("%02d", $mainCount); ?><span>/</span></div>
                            <div class="total"><?= sprintf("%02d", $bannerCount); ?></div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <?php } ?>
    </div>
    <?php if($socials) { ?>
    <ul class="socials">
        <?php foreach($socials as $social) { ?>
            <li>
                <a href="<?= $social['full_url']; ?>" target="_blank" title="<?= $social['platform_text']; ?>">
                    <span class="fa-stack">
                       <span class="fas fa-circle fa-stack-2x"></span>
                       <span class="fab fa-stack-1x social-icon <?= $social['platform'] ?>"></span>
                    </span>
                </a>
            </li>
        <?php } ?>
    </ul>
    <?php } ?>
    <div class="standard-swiper-pagination"></div>
    </div>

    <div class="holder">
        <div class="standard-thumbnail-swiper">
            <div class="swiper-wrapper">
                <?php foreach($bannerItems as $item) { $thumbnailCount++; ?>
                    <div class="swiper-slide">
                        <div class="thumbnail-item">
                            <div class="number"><?= sprintf("%02d", $thumbnailCount) . '.'; ?></div>
                            <?php if($item['banner_label']) { ?><div class="label"><?= $item['banner_label']; ?></div><?php } ?>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>

</section>
