<?php
$address = get_sub_field('address');
$phone = get_field('contact_phone_number', 'option');
$email = get_field('contact_email_address', 'option');
$formShortcode = get_sub_field('form_shortcode');
$title = get_sub_field('title');
$slogan = get_sub_field('slogan');
$image = get_sub_field('image');
?>

<section class="custom-flexible-section contact-section">
    <div class="container-fluid">
        <div class="row no-gutters row-eq-heght">
            <div class="col-md-6 image-col">
                <img src="<?= $image['url']; ?>" alt="<?= $image['alt']; ?>">
            </div>
            <div class="col-md-6 content-col">
                <div class="content-wrapper">
                    <div class="title-holder">
                        <div class="slogan"><?= $slogan; ?></div>
                        <h1><?= $title; ?></h1>
                    </div>
                    <div class="contact-wrapper">
                        <div class="top">
                            <div class="address">
                                <?= $address; ?>
                            </div>
                            <div class="details">
                                <ul>
                                    <?php if($phone) { ?><li><span class="far fa-mobile custom-icon"></span><a href="tel:<?= $phone; ?>"><?= $phone; ?></a></li><?php } ?>
                                    <?php if($email) { ?><li><span class="far fa-envelope custom-icon"></span><a href="mailto:<?= $email; ?>"><?= $email; ?></a></li><?php } ?>
                                </ul>
                            </div>
                        </div>
                        <?php if($formShortcode) { ?>
                            <div class="form">
                                <?= do_shortcode($formShortcode); ?>
                            </div>
                        <?php } ?>
                    </div>
                </div>

            </div>
        </div>
    </div>
</section>
