<?php
$title = get_sub_field('banner_title');
$cta = get_sub_field('banner_cta');
$points = get_sub_field('banner_points');
$bgImage = get_sub_field('banner_background_image');
?>

<section class="custom-flexible-section banner-section" <?php if($bgImage) { ?>style="background-image:url('<?= $bgImage['url']; ?>')"<?php } ?>>
    <div class="contain">

        <div class="primary">
            <h2><?= $title; ?></h2>
            <?php if($cta) { ?><div class="cta"><a href="<?= $cta['url']; ?>" target="<?= $cta['target']; ?>"><?= $cta['title']; ?> <span class="fas fa-chevron-right"></span></a></div><?php } ?>
        </div>
        <?php if($points) { ?>
        <div class="secondary">
            <ul>
                <?php foreach($points as $point) { ?>
                    <li><?= $point['point']; ?><span>.</span></li>
                <?php } ?>
            </ul>
        </div>
        <?php } ?>
    </div>
</section>
