<?php
namespace Blue2\Scruffy;

class Site extends \Blue2\Common\Site
{
    public function __construct()
    {
        parent::__construct();

        add_action('after_setup_theme', [$this, 'registerMenus']);
        add_filter('excerpt_more', [$this, 'tidyExcerpt']);

        $this->registerShortCodes();
        $this->registerFilters();
        $this->registerActions();
        $this->setupControllers();
    }

    public function registerMenus()
    {
        register_nav_menus([
            'main_menu' => 'Main Menu',
            'footer_menu' => 'Footer Menu'
        ]);
    }

    public function tidyExcerpt()
    {
        return '...';
    }

    private function registerShortCodes()
    {
        // Empty
    }

    private function registerFilters(){
        // Empty
    }

    private function registerActions() {
        add_action('init', [$this, 'registerPostTypes']);
        add_action('login_enqueue_scripts', [$this, 'customLoginStylesheet']);
        add_action('admin_menu', [$this, 'customAdminPages']);
        add_action('init', [$this, 'customImageSizes']);
    }

    private function setupControllers(){
        //Empty
    }

    public function registerPostTypes()
    {
        Post\Project::registerPostType();
        Post\Team::registerPostType();
    }

    public function customAdminPages()
    {
        if (function_exists('acf_add_options_page')) {
            acf_add_options_page([
                'title' => 'News Settings',
                'parent' => 'edit.php',
                'capability' => 'edit_posts',
            ]);
            acf_add_options_page([
                'title' => 'Team Settings',
                'parent' => 'edit.php?post_type=team',
                'capability' => 'edit_posts',
            ]);
            acf_add_options_page([
                'title' => 'Project Settings',
                'parent' => 'edit.php?post_type=project',
                'capability' => 'edit_posts',
            ]);
        }
    }

    public function customImageSizes()
    {

    }

    public static function getDefaultImage($id = null)
    {
        $path = get_template_directory() . '/dist/images/arktx.svg';
        $label = 'Arktx Chartered Architects';
        $file = file_get_contents($path);
        // remove xml header
        $file = str_replace(
            '<?xml version="1.0" encoding="UTF-8"?>',
            '',
            $file
        );
        // add class and attributes for accessibility
        return str_replace(
            '<svg',
            '<svg class="default-image" role="img" aria-label="' . $label . '"',
            $file
        );
    }

    public static function acfImage($id, $size, $postID = null)
    {
        if ($id) {
            $imageAlt = get_post_meta($id, '_wp_attachment_image_alt', true);
            $imageDetails = wp_get_attachment_image_src($id, $size);
            $image = '<img src="' . $imageDetails[0] . '" alt="' . $imageAlt . '" loading="lazy"/>';
            $imageClass = 'featured-image';
        } else {
            $image = self::getDefaultImage($postID);
            $imageClass = 'default-image';
        }
        return ['output' => $image, 'class' => $imageClass];
    }

    public static function inlineSVG($location, $class, $label = '', $hidden = false)
    {
        $path = get_template_directory() . $location;
        $ariaValue = $hidden == 1 ? 'true' : 'false';
        $file = file_get_contents($path);
        $file = str_replace(
            '<?xml version="1.0" encoding="UTF-8"?>',
            '',
            $file
        );
        echo str_replace(
            '<svg',
            '<svg class="' . $class . '" role="img" aria-label="' . $label . '" aria-hidden="' . $ariaValue .'"',
            $file
        );
    }

    public function customLoginStylesheet()
    {
        wp_enqueue_style('custom-login', get_stylesheet_directory_uri() . '/assets/styles/login.css');
    }

}
