
<?php 
$backgroundImage = get_field('background_image', $term_object) ?  
    wp_get_attachment_image_src(get_field('background_image', $term_object), 'full') : ""; 
$title = $term_object->name;
$url = get_category_link($term_object->term_id, $term_object->term_id);
$productsOrder = $productPosition == 'right' ? 'order-lg-2' : 'order-lg-1';
$textOrder = $productPosition == 'right' ? 'order-lg-1' : 'order-lg-2';
$backgroundPosition = $archive == false && get_field('background_image_position', $term_object) ? get_field('background_image_position', $term_object) : "";
?>

<section class="section category-cat-archive <?php if($backgroundImage) { ?>bg-img<?php } ?> <?= $backgroundPosition; ?>" 
    <?php if($backgroundImage && $archive == false) { ?>style="background-image:url('<?= $backgroundImage[0]; ?>');"<?php } ?>>
	<div class="container <?php if(isset($borderBottom)) { echo $borderBottom; } ?>">
        <div class="row">
            <div class="col-12 col-lg-4 <?php if(isset($textOrder)) { echo $textOrder; } ?>">
                <?php if ( apply_filters( 'woocommerce_show_page_title', true ) ) : ?>
                    <a class="cat-title" href="<?= $url; ?>"><h1 class="woocommerce-products-header__title page-title"><?= $title; ?></h1></a>
                <?php endif; ?>

                <div class="description">
                    <?= $term_object->description; ?>
                </div>

                <?php if(get_field('store', $term_object)) { ?>
                    <div class="stores">
                        <?php
                        foreach(get_field('store', $term_object) as $store) {
                            if(wp_get_post_terms($store, 'group')) {
                                $term = wp_get_post_terms($store, 'group');
                                $image = get_field('image', $term[0]);
                                if($image) {
                                    $imageAlt = $image ? get_post_meta($image, '_wp_attachment_image_alt', true) : get_the_title($term);
                                    $image =  wp_get_attachment_image_src($image, 'medium');
                                    ?>
                                    <img class="img-fluid" src="<?= $image[0]; ?>" alt="<?= $imageAlt; ?>"/>
                                    <?php
                                }
                            }
                        } 
                        ?>
                    </div>
                <?php } ?>
            </div>
            <div class="col-12 col-lg-8 <?php if(isset($productsOrder)) { echo $productsOrder; } ?>">
                <?php include(locate_template( 'templates/parts/grid-product.php' )); ?>
            </div>
        </div>
    </div>
</section>