<?php
$label = get_sub_field('call_to_action_label');
$url = get_sub_field('call_to_action_url');
$productImageId = get_sub_field('image');
$productImage = $productImageId ? wp_get_attachment_image_src($productImageId, 'general-tile') : false;
$productImageAlt = get_post_meta(get_post_thumbnail_id($productImageId), '_wp_attachment_image_alt', true) ?: 
		get_sub_field('title');
if($productImage !== false) {		
?>
	<figure class="tile tile--caption tile--img-hover">
		<?php if($label && $url) { ?>
			<a href="<?= $url; ?>">
				<span class="cta btn-graphic"><?= $label; ?></span>
		<?php } ?>

			<?php if(get_sub_field('title')) { ?>
				<h3 class="accent-title" ><?php the_sub_field('title'); ?></h3>
			<?php } ?>

			<img class="img-fluid" src="<?= $productImage[0]; ?>" alt="<?= $productImageAlt; ?>" />

			<?php if(get_sub_field('caption')) { ?>
				<figcaption class="tile--caption--text"><p><?php the_sub_field('caption'); ?></p></figcaption>
			<?php } ?>

			<?php if($label && $url) { ?>
				</a>
			<?php } ?>
	</figure>
<?php }